/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.entities.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.dv8tion.jda.client.entities.Call;
import net.dv8tion.jda.client.entities.CallUser;
import net.dv8tion.jda.client.entities.CallableChannel;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.PrivateChannel;

public class CallImpl
implements Call {
    private final CallableChannel callableChannel;
    private final String messageId;
    private HashMap<String, CallUser> callUsers = new HashMap();
    private HashMap<String, CallUser> callUserHistory = new HashMap();
    private Region region;

    public CallImpl(CallableChannel callableChannel, String messageId) {
        this.callableChannel = callableChannel;
        this.messageId = messageId;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean isGroupCall() {
        return this.callableChannel instanceof Group;
    }

    @Override
    public CallableChannel getCallableChannel() {
        return this.callableChannel;
    }

    @Override
    public Group getGroup() {
        return this.isGroupCall() ? (Group)this.callableChannel : null;
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        return !this.isGroupCall() ? (PrivateChannel)this.callableChannel : null;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public List<CallUser> getRingingUsers() {
        return Collections.unmodifiableList(this.callUsers.values().stream().filter(cu -> cu.isRinging()).collect(Collectors.toList()));
    }

    @Override
    public List<CallUser> getConnectedUsers() {
        return Collections.unmodifiableList(this.callUsers.values().stream().filter(cu -> cu.getVoiceState().isInCall()).collect(Collectors.toList()));
    }

    @Override
    public List<CallUser> getCallUserHistory() {
        return Collections.unmodifiableList(new ArrayList<CallUser>(this.callUserHistory.values()));
    }

    @Override
    public List<CallUser> getAllCallUsers() {
        return Collections.unmodifiableList(new ArrayList<CallUser>(this.callUsers.values()));
    }

    @Override
    public String getId() {
        return this.callableChannel.getId();
    }

    public String toString() {
        return "Call(" + this.getId() + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Call)) {
            return false;
        }
        Call oCall = (Call)o;
        return this.getId().equals(oCall.getId()) && Objects.equals(this.messageId, oCall.getMessageId());
    }

    public int hashCode() {
        return ("Call " + this.getId()).hashCode();
    }

    public CallImpl setRegion(Region region) {
        this.region = region;
        return this;
    }

    public HashMap<String, CallUser> getCallUserMap() {
        return this.callUsers;
    }

    public HashMap<String, CallUser> getCallUserHistoryMap() {
        return this.callUserHistory;
    }
}

