/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.vimeo;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VimeoAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(VimeoAudioTrack.class);
    private final VimeoAudioSourceManager sourceManager;

    public VimeoAudioTrack(AudioTrackInfo trackInfo, VimeoAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (CloseableHttpClient httpClient = this.sourceManager.createHttpClient();){
            String playbackUrl = this.loadPlaybackUrl(httpClient);
            log.debug("Starting Vimeo track from URL: {}", (Object)playbackUrl);
            try (PersistentHttpStream stream = new PersistentHttpStream(httpClient, new URI(playbackUrl), null);){
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private String loadPlaybackUrl(CloseableHttpClient httpClient) throws IOException {
        JsonBrowser config = this.loadPlayerConfig(httpClient);
        if (config == null) {
            throw new FriendlyException("Track information not present on the page.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        String trackConfigUrl = config.get("player").get("config_url").text();
        JsonBrowser trackConfig = this.loadTrackConfig(httpClient, trackConfigUrl);
        return trackConfig.get("request").get("files").get("progressive").index(0).get("url").text();
    }

    private JsonBrowser loadPlayerConfig(CloseableHttpClient httpClient) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet(this.trackInfo.identifier));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code for player config is " + statusCode));
            }
            JsonBrowser jsonBrowser = this.sourceManager.loadConfigJsonFromPageContent(IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            return jsonBrowser;
        }
    }

    private JsonBrowser loadTrackConfig(CloseableHttpClient httpClient, String trackAccessInfoUrl) throws IOException {
        try (CloseableHttpResponse response = httpClient.execute(new HttpGet(trackAccessInfoUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code for track access info is " + statusCode));
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    @Override
    public AudioTrack makeClone() {
        return new VimeoAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

