/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.remote.message;

import com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessage;
import com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessageCodec;
import com.sedmelluq.discord.lavaplayer.remote.message.RemoteMessageType;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;

public class RemoteMessageMapper {
    private final Map<Class<? extends RemoteMessage>, RemoteMessageType> encodingMap = new IdentityHashMap<Class<? extends RemoteMessage>, RemoteMessageType>();

    public RemoteMessageMapper() {
        this.initialiseEncodingMap();
    }

    private void initialiseEncodingMap() {
        for (RemoteMessageType type : (RemoteMessageType[])RemoteMessageType.class.getEnumConstants()) {
            this.encodingMap.put(type.codec.getMessageClass(), type);
        }
    }

    public RemoteMessage decode(DataInput input) throws IOException {
        int messageSize = input.readInt();
        if (messageSize == 0) {
            return null;
        }
        RemoteMessageType type = ((RemoteMessageType[])RemoteMessageType.class.getEnumConstants())[input.readByte() & 0xFF];
        return type.codec.decode(input);
    }

    public void encode(DataOutputStream output, RemoteMessage message) throws IOException {
        RemoteMessageType type = this.encodingMap.get(message.getClass());
        ByteArrayOutputStream messageOutputBytes = new ByteArrayOutputStream();
        DataOutputStream messageOutput = new DataOutputStream(messageOutputBytes);
        RemoteMessageCodec<?> codec = type.codec;
        codec.encode(messageOutput, message);
        output.writeInt(messageOutputBytes.size() + 1);
        output.writeByte((byte)type.ordinal());
        messageOutputBytes.writeTo(output);
    }

    public void endOutput(DataOutputStream output) throws IOException {
        output.writeInt(0);
    }
}

