/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.file;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.spi.MidiFileWriter;
import org.tritonus.share.TDebug;

public class StandardMidiFileWriter
extends MidiFileWriter {
    public static boolean USE_RUNNING_STATUS = true;
    public static boolean CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX = true;

    @Override
    public int[] getMidiFileTypes() {
        return new int[]{0, 1};
    }

    @Override
    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] tracks = sequence.getTracks();
        if (tracks.length == 1) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    @Override
    public int write(Sequence sequence, int nFileType, OutputStream outputStream) throws IOException {
        if (!this.isFileTypeSupported(nFileType, sequence)) {
            throw new IllegalArgumentException("file type is not supported for this sequence");
        }
        Track[] aTracks = sequence.getTracks();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(1297377380);
        dataOutputStream.writeInt(6);
        dataOutputStream.writeShort(nFileType);
        dataOutputStream.writeShort(aTracks.length);
        float fDivisionType = sequence.getDivisionType();
        int nResolution = sequence.getResolution();
        int nDivision = 0;
        if (fDivisionType == 0.0f) {
            nDivision = nResolution & Short.MAX_VALUE;
        }
        dataOutputStream.writeShort(nDivision);
        int nBytesWritten = 14;
        for (int nTrack = 0; nTrack < aTracks.length; ++nTrack) {
            nBytesWritten += StandardMidiFileWriter.writeTrack(aTracks[nTrack], dataOutputStream);
        }
        return nBytesWritten;
    }

    @Override
    public int write(Sequence sequence, int nFileType, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        int nBytes = this.write(sequence, nFileType, outputStream);
        ((OutputStream)outputStream).close();
        return nBytes;
    }

    private static int writeTrack(Track track, DataOutputStream dataOutputStream) throws IOException {
        int nLength = 0;
        if (dataOutputStream != null) {
            dataOutputStream.writeInt(1297379947);
        }
        int nTrackLength = 0;
        if (dataOutputStream != null) {
            nTrackLength = StandardMidiFileWriter.writeTrack(track, null);
        }
        if (dataOutputStream != null) {
            dataOutputStream.writeInt(nTrackLength);
        }
        MidiEvent previousEvent = null;
        int[] anRunningStatusByte = new int[]{-1};
        for (int nEvent = 0; nEvent < track.size(); ++nEvent) {
            MidiEvent event = track.get(nEvent);
            nLength += StandardMidiFileWriter.writeEvent(event, previousEvent, anRunningStatusByte, dataOutputStream);
            previousEvent = event;
        }
        return nLength;
    }

    private static int writeEvent(MidiEvent event, MidiEvent previousEvent, int[] anRunningStatusByte, DataOutputStream dataOutputStream) throws IOException {
        int nLength = 0;
        long lTickDelta = 0L;
        if (previousEvent != null) {
            lTickDelta = event.getTick() - previousEvent.getTick();
        }
        if (lTickDelta < 0L) {
            TDebug.out("StandardMidiFileWriter.writeEvent(): warning: events not in order");
        }
        nLength += StandardMidiFileWriter.writeVariableLengthQuantity(lTickDelta, dataOutputStream);
        MidiMessage message = event.getMessage();
        if (message instanceof ShortMessage) {
            nLength += StandardMidiFileWriter.writeShortMessage((ShortMessage)message, anRunningStatusByte, dataOutputStream);
        } else if (message instanceof SysexMessage) {
            nLength += StandardMidiFileWriter.writeSysexMessage((SysexMessage)message, anRunningStatusByte, dataOutputStream);
        } else if (message instanceof MetaMessage) {
            nLength += StandardMidiFileWriter.writeMetaMessage((MetaMessage)message, anRunningStatusByte, dataOutputStream);
        } else {
            TDebug.out("StandardMidiFileWriter.writeEvent(): warning: unknown message class");
        }
        return nLength;
    }

    private static int writeShortMessage(ShortMessage message, int[] anRunningStatusByte, DataOutputStream dataOutputStream) throws IOException {
        int nLength = 0;
        int nDataLength = message.getLength();
        if (USE_RUNNING_STATUS && anRunningStatusByte[0] == message.getStatus()) {
            if (dataOutputStream != null) {
                dataOutputStream.write(message.getMessage(), 1, nDataLength - 1);
            }
            nLength += nDataLength - 1;
        } else {
            if (dataOutputStream != null) {
                dataOutputStream.write(message.getMessage(), 0, nDataLength);
            }
            nLength += nDataLength;
            anRunningStatusByte[0] = message.getStatus();
        }
        return nLength;
    }

    private static int writeSysexMessage(SysexMessage message, int[] anRunningStatusByte, DataOutputStream dataOutputStream) throws IOException {
        int nLength = 0;
        int nDataLength = message.getLength();
        if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
            anRunningStatusByte[0] = -1;
        }
        if (dataOutputStream != null) {
            dataOutputStream.write(message.getStatus());
        }
        ++nLength;
        nLength += StandardMidiFileWriter.writeVariableLengthQuantity(nDataLength - 1, dataOutputStream);
        if (dataOutputStream != null) {
            dataOutputStream.write(message.getData(), 0, nDataLength - 1);
        }
        return nLength += nDataLength - 1;
    }

    private static int writeMetaMessage(MetaMessage message, int[] anRunningStatusByte, DataOutputStream dataOutputStream) throws IOException {
        int nLength = 0;
        byte[] abData = message.getData();
        int nDataLength = abData.length;
        if (CANCEL_RUNNING_STATUS_ON_META_AND_SYSEX) {
            anRunningStatusByte[0] = -1;
        }
        if (dataOutputStream != null) {
            dataOutputStream.write(message.getStatus());
            dataOutputStream.write(message.getType());
        }
        nLength += 2;
        nLength += StandardMidiFileWriter.writeVariableLengthQuantity(nDataLength, dataOutputStream);
        if (dataOutputStream != null) {
            dataOutputStream.write(abData);
        }
        return nLength += nDataLength;
    }

    private static int writeVariableLengthQuantity(long lValue, OutputStream outputStream) throws IOException {
        int nLength = 0;
        boolean bWritingStarted = false;
        int nByte = (int)(lValue >> 21 & 0x7FL);
        if (nByte != 0) {
            if (outputStream != null) {
                outputStream.write(nByte | 0x80);
            }
            ++nLength;
            bWritingStarted = true;
        }
        if ((nByte = (int)(lValue >> 14 & 0x7FL)) != 0 || bWritingStarted) {
            if (outputStream != null) {
                outputStream.write(nByte | 0x80);
            }
            ++nLength;
            bWritingStarted = true;
        }
        if ((nByte = (int)(lValue >> 7 & 0x7FL)) != 0 || bWritingStarted) {
            if (outputStream != null) {
                outputStream.write(nByte | 0x80);
            }
            ++nLength;
        }
        nByte = (int)(lValue & 0x7FL);
        if (outputStream != null) {
            outputStream.write(nByte);
        }
        return ++nLength;
    }
}

