/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import net.dv8tion.jda.player.AbstractMusicPlayer;
import net.dv8tion.jda.player.source.AudioStream;
import net.dv8tion.jda.player.source.AudioTimestamp;

public class RemoteStream
extends AudioStream {
    private Process ytdlProcess;
    private Process ffmpegProcess;
    private Thread ytdlToFFmpegThread;
    private Thread ytdlErrGobler;
    private Thread ffmpegErrGobler;
    private List<String> ytdlLaunchArgs;
    private List<String> ffmpegLaunchArgs;
    private AudioTimestamp timestamp = AudioTimestamp.fromSeconds(0);

    protected RemoteStream(List<String> ytdlLaunchArgs, List<String> ffmpegLaunchArgs) {
        try {
            ProcessBuilder pBuilder = new ProcessBuilder(new String[0]);
            pBuilder.command(ytdlLaunchArgs);
            AbstractMusicPlayer.LOG.debug("Command: " + pBuilder.command());
            this.ytdlProcess = pBuilder.start();
            pBuilder.command(ffmpegLaunchArgs);
            AbstractMusicPlayer.LOG.debug("Command: " + pBuilder.command());
            this.ffmpegProcess = pBuilder.start();
            final Process ytdlProcessF = this.ytdlProcess;
            final Process ffmpegProcessF = this.ffmpegProcess;
            this.ytdlToFFmpegThread = new Thread("RemoteSource ytdlToFFmpeg Bridge"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream fromYTDL = null;
                    OutputStream toFFmpeg = null;
                    try {
                        fromYTDL = ytdlProcessF.getInputStream();
                        toFFmpeg = ffmpegProcessF.getOutputStream();
                        byte[] buffer = new byte[1024];
                        int amountRead = -1;
                        while (!this.isInterrupted() && (amountRead = fromYTDL.read(buffer)) > -1) {
                            toFFmpeg.write(buffer, 0, amountRead);
                        }
                        toFFmpeg.flush();
                    }
                    catch (IOException e) {
                        String msg = e.getMessage().toLowerCase();
                        if (e.getMessage().contains("The pipe has been ended") || e.getMessage().contains("Broken pipe")) {
                            AbstractMusicPlayer.LOG.trace("RemoteStream encountered an 'error' : " + e.getMessage() + " (not really an error.. probably)");
                        } else {
                            AbstractMusicPlayer.LOG.log(e);
                        }
                    }
                    finally {
                        try {
                            if (fromYTDL != null) {
                                fromYTDL.close();
                            }
                        }
                        catch (Throwable throwable) {}
                        try {
                            if (toFFmpeg != null) {
                                toFFmpeg.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            this.ytdlErrGobler = new Thread("RemoteStream ytdlErrGobler"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream fromYTDL = null;
                    try {
                        fromYTDL = ytdlProcessF.getErrorStream();
                        if (fromYTDL == null) {
                            AbstractMusicPlayer.LOG.fatal("RemoteStream: YTDL-ErrGobler: fromYTDL is null");
                        }
                        byte[] buffer = new byte[1024];
                        int amountRead = -1;
                        while (!this.isInterrupted() && (amountRead = fromYTDL.read(buffer)) > -1) {
                            AbstractMusicPlayer.LOG.warn("ERR YTDL: " + new String(Arrays.copyOf(buffer, amountRead)));
                        }
                    }
                    catch (IOException e) {
                        AbstractMusicPlayer.LOG.log(e);
                    }
                    finally {
                        try {
                            if (fromYTDL != null) {
                                fromYTDL.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            this.ffmpegErrGobler = new Thread("RemoteStream ffmpegErrGobler"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream fromFFmpeg = null;
                    try {
                        fromFFmpeg = ffmpegProcessF.getErrorStream();
                        if (fromFFmpeg == null) {
                            AbstractMusicPlayer.LOG.fatal("RemoteStream: FFmpeg-ErrGobler: fromYTDL is null");
                        }
                        byte[] buffer = new byte[1024];
                        int amountRead = -1;
                        while (!this.isInterrupted() && (amountRead = fromFFmpeg.read(buffer)) > -1) {
                            Matcher m;
                            String info = new String(Arrays.copyOf(buffer, amountRead));
                            if (!info.contains("time=") || !(m = AudioStream.TIME_PATTERN.matcher(info)).find()) continue;
                            RemoteStream.this.timestamp = AudioTimestamp.fromFFmpegTimestamp(m.group());
                        }
                    }
                    catch (IOException e) {
                        AbstractMusicPlayer.LOG.log(e);
                    }
                    finally {
                        try {
                            if (fromFFmpeg != null) {
                                fromFFmpeg.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            this.ytdlToFFmpegThread.start();
            this.ytdlErrGobler.start();
            this.ffmpegErrGobler.start();
            this.in = this.ffmpegProcess.getInputStream();
        }
        catch (IOException e) {
            AbstractMusicPlayer.LOG.log(e);
            try {
                this.close();
            }
            catch (IOException e1) {
                AbstractMusicPlayer.LOG.log(e1);
            }
        }
    }

    @Override
    public AudioTimestamp getCurrentTimestamp() {
        return this.timestamp;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ytdlToFFmpegThread != null) {
                this.ytdlToFFmpegThread.interrupt();
                this.ytdlToFFmpegThread = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ytdlErrGobler != null) {
                this.ytdlErrGobler.interrupt();
                this.ytdlErrGobler = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ffmpegErrGobler != null) {
                this.ffmpegErrGobler.interrupt();
                this.ffmpegErrGobler = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ffmpegProcess != null) {
                this.ffmpegProcess.destroyForcibly();
                this.ffmpegProcess = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ytdlProcess != null) {
                this.ytdlProcess.destroyForcibly();
                this.ytdlProcess = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            super.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

