/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.player.AbstractMusicPlayer;
import net.dv8tion.jda.player.source.AudioInfo;
import net.dv8tion.jda.player.source.AudioSource;
import net.dv8tion.jda.player.source.AudioStream;
import net.dv8tion.jda.player.source.AudioTimestamp;
import net.dv8tion.jda.player.source.LocalSource;
import net.dv8tion.jda.player.source.RemoteStream;
import org.json.JSONException;
import org.json.JSONObject;
import sun.misc.IOUtils;

public class RemoteSource
implements AudioSource {
    public static final List<String> YOUTUBE_DL_LAUNCH_ARGS = Collections.unmodifiableList(Arrays.asList("python", "./youtube-dl", "-q", "-f", "bestaudio/best", "--no-playlist", "-4", "--no-cache-dir", "-o", "-"));
    public static final List<String> FFMPEG_LAUNCH_ARGS = Collections.unmodifiableList(Arrays.asList("ffmpeg", "-i", "-", "-f", "s16be", "-ac", "2", "-ar", "48000", "-map", "a", "-"));
    private final String url;
    private final List<String> ytdlLaunchArgsF;
    private final List<String> ffmpegLaunchArgsF;
    private AudioInfo audioInfo;

    public RemoteSource(String url) {
        this(url, null, null);
    }

    public RemoteSource(String url, List<String> ytdlLaunchArgs, List<String> ffmpegLaunchArgs) {
        if (url == null || url.isEmpty()) {
            throw new NullPointerException("String url provided to RemoteSource was null or empty.");
        }
        this.url = url;
        this.ytdlLaunchArgsF = ytdlLaunchArgs;
        this.ffmpegLaunchArgsF = ffmpegLaunchArgs;
    }

    @Override
    public String getSource() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AudioInfo getInfo() {
        if (this.audioInfo != null) {
            return this.audioInfo;
        }
        LinkedList<String> infoArgs = new LinkedList<String>();
        if (this.ytdlLaunchArgsF != null) {
            infoArgs.addAll(this.ytdlLaunchArgsF);
            if (!infoArgs.contains("-q")) {
                infoArgs.add("-q");
            }
        } else {
            infoArgs.addAll(YOUTUBE_DL_LAUNCH_ARGS);
        }
        infoArgs.add("--ignore-errors");
        infoArgs.add("--no-warnings");
        infoArgs.add("-j");
        infoArgs.add("--skip-download");
        infoArgs.add("--");
        infoArgs.add(this.url);
        this.audioInfo = new AudioInfo();
        Process ytdlProcess = null;
        Process ffprobeProcess = null;
        InputStream ytdlStream = null;
        InputStream ffprobeStream = null;
        try {
            ytdlProcess = new ProcessBuilder(new String[0]).command(infoArgs).start();
            ytdlStream = ytdlProcess.getErrorStream();
            byte[] infoData = IOUtils.readFully((InputStream)ytdlStream, (int)-1, (boolean)false);
            if (infoData == null || infoData.length == 0) {
                throw new NullPointerException("The Youtube-DL process resulted in a null or zero-length INFO!");
            }
            String infoString = new String(infoData);
            if (infoString.startsWith("ERROR")) {
                this.audioInfo.error = infoString;
            } else {
                JSONObject info;
                this.audioInfo.jsonInfo = info = new JSONObject(infoString);
                this.audioInfo.title = !info.optString("title", "").isEmpty() ? info.getString("title") : (!info.optString("fulltitle", "").isEmpty() ? info.getString("fulltitle") : null);
                this.audioInfo.origin = !info.optString("webpage_url", "").isEmpty() ? info.getString("webpage_url") : this.url;
                String string = this.audioInfo.id = !info.optString("id", "").isEmpty() ? info.getString("id") : null;
                this.audioInfo.encoding = !info.optString("acodec", "").isEmpty() ? info.getString("acodec") : (!info.optString("ext", "").isEmpty() ? info.getString("ext") : null);
                String string2 = this.audioInfo.description = !info.optString("description", "").isEmpty() ? info.getString("description") : null;
                this.audioInfo.extractor = !info.optString("extractor", "").isEmpty() ? info.getString("extractor") : (!info.optString("extractor_key").isEmpty() ? info.getString("extractor_key") : null);
                this.audioInfo.thumbnail = !info.optString("thumbnail", "").isEmpty() ? info.getString("thumbnail") : null;
                this.audioInfo.isLive = info.has("is_live") && !info.isNull("is_live") && info.getBoolean("is_live");
                AudioTimestamp audioTimestamp = this.audioInfo.duration = info.optInt("duration", -1) != -1 ? AudioTimestamp.fromSeconds(info.getInt("duration")) : null;
                if (this.audioInfo.duration == null) {
                    LinkedList<String> ffprobeInfoArgs = new LinkedList<String>();
                    ffprobeInfoArgs.addAll(LocalSource.FFPROBE_INFO_ARGS);
                    ffprobeInfoArgs.add("-i");
                    ffprobeInfoArgs.add(info.optString("url", this.url));
                    ffprobeProcess = new ProcessBuilder(new String[0]).command(ffprobeInfoArgs).start();
                    ffprobeStream = ffprobeProcess.getInputStream();
                    infoData = IOUtils.readFully((InputStream)ffprobeStream, (int)-1, (boolean)false);
                    if (infoData != null && infoData.length > 0 && (info = new JSONObject(new String(infoData)).getJSONObject("format")).optDouble("duration", -1.0) != -1.0) {
                        int duration = Math.round((float)info.getDouble("duration"));
                        this.audioInfo.duration = AudioTimestamp.fromSeconds(duration);
                    }
                }
            }
        }
        catch (IOException | JSONException e) {
            this.audioInfo.error = e.getMessage();
            AbstractMusicPlayer.LOG.log(e);
        }
        finally {
            try {
                if (ytdlProcess != null) {
                    ytdlProcess.destroyForcibly();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (ytdlStream != null) {
                    ytdlStream.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (ffprobeProcess != null) {
                    ffprobeProcess.destroyForcibly();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (ffprobeStream != null) {
                    ffprobeStream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return this.audioInfo;
    }

    @Override
    public AudioStream asStream() {
        ArrayList<String> ytdlLaunchArgs = new ArrayList<String>();
        ArrayList<String> ffmpegLaunchArgs = new ArrayList<String>();
        if (this.ytdlLaunchArgsF == null) {
            ytdlLaunchArgs.addAll(YOUTUBE_DL_LAUNCH_ARGS);
        } else {
            ytdlLaunchArgs.addAll(this.ytdlLaunchArgsF);
            if (!ytdlLaunchArgs.contains("-q")) {
                ytdlLaunchArgs.add("-q");
            }
        }
        if (this.ffmpegLaunchArgsF == null) {
            ffmpegLaunchArgs.addAll(FFMPEG_LAUNCH_ARGS);
        } else {
            ffmpegLaunchArgs.addAll(this.ffmpegLaunchArgsF);
        }
        ytdlLaunchArgs.add("--");
        ytdlLaunchArgs.add(this.url);
        return new RemoteStream(ytdlLaunchArgs, ffmpegLaunchArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File asFile(String path, boolean deleteIfExists) throws FileAlreadyExistsException, FileNotFoundException {
        if (path == null || path.isEmpty()) {
            throw new NullPointerException("Provided path was null or empty!");
        }
        File file = new File(path);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("The provided path is a directory, not a file!");
        }
        if (file.exists()) {
            if (!deleteIfExists) {
                throw new FileAlreadyExistsException("The provided path already has an existing file  and the `deleteIfExists` boolean was set to false.");
            }
            if (!file.delete()) {
                throw new UnsupportedOperationException("Cannot delete the file. Is it in use?");
            }
        }
        Thread currentThread = Thread.currentThread();
        FileOutputStream fos = new FileOutputStream(file);
        AudioStream input = this.asStream();
        try {
            byte[] buffer = new byte[1024];
            int amountRead = -1;
            boolean i = false;
            while (!currentThread.isInterrupted() && (amountRead = ((InputStream)input).read(buffer)) > -1) {
                fos.write(buffer, 0, amountRead);
            }
            fos.flush();
        }
        catch (IOException e) {
            AbstractMusicPlayer.LOG.log(e);
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                AbstractMusicPlayer.LOG.log(e);
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                AbstractMusicPlayer.LOG.log(e);
            }
        }
        return file;
    }
}

