/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player.source;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import net.dv8tion.jda.player.AbstractMusicPlayer;
import net.dv8tion.jda.player.source.AudioStream;
import net.dv8tion.jda.player.source.AudioTimestamp;

public class LocalStream
extends AudioStream {
    private Process ffmpegProcess;
    private Thread ffmpegErrGobler;
    private AudioTimestamp timestamp;

    public LocalStream(List<String> ffmpegLaunchArgs) {
        try {
            ProcessBuilder pBuilder = new ProcessBuilder(new String[0]);
            pBuilder.command(ffmpegLaunchArgs);
            AbstractMusicPlayer.LOG.debug("Command: " + pBuilder.command());
            final Process ffmpegProcessF = this.ffmpegProcess = pBuilder.start();
            this.ffmpegErrGobler = new Thread("LocalStream ffmpegErrGobler"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream fromFFmpeg = null;
                    try {
                        fromFFmpeg = ffmpegProcessF.getErrorStream();
                        if (fromFFmpeg == null) {
                            AbstractMusicPlayer.LOG.fatal("LocalStream: ErrGobler: fromFFmpeg is null");
                        }
                        byte[] buffer = new byte[1024];
                        int amountRead = -1;
                        while (!this.isInterrupted() && (amountRead = fromFFmpeg.read(buffer)) > -1) {
                            Matcher m;
                            String info = new String(Arrays.copyOf(buffer, amountRead));
                            if (!info.contains("time=") || !(m = AudioStream.TIME_PATTERN.matcher(info)).find()) continue;
                            LocalStream.this.timestamp = AudioTimestamp.fromFFmpegTimestamp(m.group());
                        }
                    }
                    catch (IOException e) {
                        AbstractMusicPlayer.LOG.log(e);
                    }
                    finally {
                        try {
                            if (fromFFmpeg != null) {
                                fromFFmpeg.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            };
            this.ffmpegErrGobler.start();
            this.in = this.ffmpegProcess.getInputStream();
        }
        catch (IOException e) {
            AbstractMusicPlayer.LOG.log(e);
            try {
                this.close();
            }
            catch (IOException e1) {
                AbstractMusicPlayer.LOG.log(e1);
            }
        }
    }

    @Override
    public AudioTimestamp getCurrentTimestamp() {
        return this.timestamp;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ffmpegErrGobler != null) {
                this.ffmpegErrGobler.interrupt();
                this.ffmpegErrGobler = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ffmpegProcess != null) {
                this.ffmpegProcess.destroyForcibly();
                this.ffmpegProcess = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            super.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

