/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.player.AbstractMusicPlayer;
import net.dv8tion.jda.player.source.AudioInfo;
import net.dv8tion.jda.player.source.AudioSource;
import net.dv8tion.jda.player.source.AudioStream;
import net.dv8tion.jda.player.source.AudioTimestamp;
import net.dv8tion.jda.player.source.LocalStream;
import org.json.JSONException;
import org.json.JSONObject;
import sun.misc.IOUtils;

public class LocalSource
implements AudioSource {
    public static final List<String> FFMPEG_LAUNCH_ARGS = Collections.unmodifiableList(Arrays.asList("ffmpeg", "-f", "s16be", "-ac", "2", "-ar", "48000", "-map", "a", "-"));
    public static final List<String> FFPROBE_INFO_ARGS = Collections.unmodifiableList(Arrays.asList("ffprobe", "-show_format", "-print_format", "json", "-loglevel", "0"));
    private File file;
    private AudioInfo audioInfo;

    public LocalSource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Provided file was null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Provided file does not exist!");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Provided file is actually a directory. Must provide a file!");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Provided file is unreadable due to a lack of permissions");
        }
        this.file = file;
    }

    @Override
    public String getSource() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            AbstractMusicPlayer.LOG.log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AudioInfo getInfo() {
        if (this.audioInfo != null) {
            return this.audioInfo;
        }
        this.audioInfo = new AudioInfo();
        Process ffprobeProcess = null;
        InputStream ffprobeStream = null;
        try {
            LinkedList<String> infoArgs = new LinkedList<String>();
            infoArgs.addAll(FFPROBE_INFO_ARGS);
            infoArgs.add("-i");
            infoArgs.add(this.file.getCanonicalPath());
            ffprobeProcess = new ProcessBuilder(new String[0]).command(infoArgs).start();
            ffprobeStream = ffprobeProcess.getInputStream();
            byte[] infoData = IOUtils.readFully((InputStream)ffprobeStream, (int)-1, (boolean)false);
            if (infoData == null || infoData.length == 0) {
                throw new NullPointerException("The FFprobe process resulted in a null or zero-length INFO!");
            }
            JSONObject info = new JSONObject(new String(infoData));
            JSONObject format = info.getJSONObject("format");
            JSONObject tags = format.optJSONObject("tags");
            this.audioInfo.jsonInfo = info;
            this.audioInfo.origin = this.file.getCanonicalPath();
            this.audioInfo.extractor = "LocalSource";
            if (tags != null) {
                this.audioInfo.title = !tags.optString("title", "").isEmpty() ? tags.getString("title") : null;
                this.audioInfo.description = "Title: " + (tags.has("title") ? tags.getString("title") : "N/A") + "\n" + "Artist: " + (tags.has("artist") ? tags.getString("artist") : "N/A") + "\n" + "Album: " + (tags.has("album") ? tags.getString("album") : "N/A") + "\n" + "Genre: " + (tags.has("genre") ? tags.getString("genre") : "N/A") + "\n";
            }
            this.audioInfo.encoding = !format.optString("format_name", "").isEmpty() ? format.getString("format_name") : (!format.optString("format_long_name", "").isEmpty() ? format.getString("format_long_name") : null);
            this.audioInfo.duration = format.has("duration") ? AudioTimestamp.fromSeconds((int)format.getDouble("duration")) : null;
        }
        catch (IOException | JSONException e) {
            this.audioInfo.error = e.getMessage();
            AbstractMusicPlayer.LOG.log(e);
        }
        finally {
            try {
                if (ffprobeProcess != null) {
                    ffprobeProcess.destroyForcibly();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (ffprobeStream != null) {
                    ffprobeStream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return this.audioInfo;
    }

    @Override
    public AudioStream asStream() {
        LinkedList<String> ffmpegLaunchArgs = new LinkedList<String>();
        ffmpegLaunchArgs.addAll(FFMPEG_LAUNCH_ARGS);
        try {
            ffmpegLaunchArgs.add("-i");
            ffmpegLaunchArgs.add(this.file.getCanonicalPath());
            return new LocalStream(ffmpegLaunchArgs);
        }
        catch (IOException e) {
            AbstractMusicPlayer.LOG.log(e);
            return null;
        }
    }

    @Override
    public File asFile(String path, boolean deleteOnExists) throws FileAlreadyExistsException, FileNotFoundException {
        return null;
    }
}

