/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player.source;

public class AudioTimestamp {
    protected int hours;
    protected int minutes;
    protected int seconds;
    protected int milliseconds;

    public AudioTimestamp(int hours, int minutes, int seconds, int milliseconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
    }

    public String getTimestamp() {
        String timestamp = "";
        timestamp = timestamp + (this.hours != 0 ? String.format("%02d:", this.hours) : "");
        timestamp = timestamp + String.format("%02d:%02d", this.minutes, this.seconds);
        return timestamp;
    }

    public String getFullTimestamp() {
        return String.format("%02d:%02d:%02d.%03d", this.hours, this.minutes, this.seconds, this.milliseconds);
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public int getTotalSeconds() {
        return this.hours * 3600 + this.minutes * 60 + this.seconds;
    }

    public String toString() {
        return "AudioTimeStamp(" + this.getFullTimestamp() + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof AudioTimestamp)) {
            return false;
        }
        AudioTimestamp oTime = (AudioTimestamp)o;
        return oTime.hours == this.hours && oTime.minutes == this.minutes && oTime.seconds == this.seconds && oTime.milliseconds == this.milliseconds;
    }

    public static AudioTimestamp fromFFmpegTimestamp(String ffmpegTimestamp) {
        String[] timeParts = ffmpegTimestamp.split(":");
        int hours = Integer.parseInt(timeParts[0]);
        int minutes = Integer.parseInt(timeParts[1]);
        timeParts = timeParts[2].split("\\.");
        int seconds = Integer.parseInt(timeParts[0]);
        int milliseconds = Integer.parseInt(timeParts[1]) * 10;
        return new AudioTimestamp(hours, minutes, seconds, milliseconds);
    }

    public static AudioTimestamp fromSeconds(int seconds) {
        int hours = seconds / 3600;
        int minutes = (seconds %= 3600) / 60;
        return new AudioTimestamp(hours, minutes, seconds %= 60, 0);
    }
}

