/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player.hooks;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.player.AbstractMusicPlayer;
import net.dv8tion.jda.player.hooks.PlayerEventListener;
import net.dv8tion.jda.player.hooks.events.PlayerEvent;

public class PlayerEventManager {
    private final List<PlayerEventListener> listeners = new LinkedList<PlayerEventListener>();

    public void register(PlayerEventListener listener) {
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("Attempted to register a listener that is already registered");
        }
        this.listeners.add(listener);
    }

    public void unregister(PlayerEventListener listener) {
        this.listeners.remove(listener);
    }

    public void handle(PlayerEvent event) {
        LinkedList<PlayerEventListener> listenerCopy = new LinkedList<PlayerEventListener>(this.listeners);
        for (PlayerEventListener listener : listenerCopy) {
            try {
                listener.onEvent(event);
            }
            catch (Throwable throwable) {
                AbstractMusicPlayer.LOG.log(throwable);
            }
        }
    }

    public List<PlayerEventListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

