/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Scanner;
import net.dv8tion.jda.player.AbstractMusicPlayer;
import net.dv8tion.jda.player.source.AudioSource;
import net.dv8tion.jda.player.source.RemoteSource;
import org.json.JSONObject;
import sun.misc.IOUtils;

public class Playlist {
    public static final List<String> YOUTUBE_DL_PLAYLIST_ARGS = Collections.unmodifiableList(Arrays.asList("python", "./youtube-dl", "-q", "-j", "-4", "--flat-playlist"));
    protected List<AudioSource> sources;
    protected Queue<AudioSource> currentOrder;
    protected AudioSource endOfList;
    protected String name;
    protected boolean repeatSingle = false;
    protected boolean repeatList = false;
    protected boolean shuffle = false;

    public Playlist(String name) {
        this.name = name;
        this.sources = new ArrayList<AudioSource>();
    }

    public List<AudioSource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Playlist getPlaylist(String url) {
        LinkedList<String> infoArgs = new LinkedList<String>();
        infoArgs.addAll(YOUTUBE_DL_PLAYLIST_ARGS);
        infoArgs.add("--");
        infoArgs.add(url);
        ArrayList<AudioSource> sources = new ArrayList<AudioSource>();
        Scanner scan = null;
        Process infoProcess = null;
        InputStream infoStream = null;
        try {
            infoProcess = new ProcessBuilder(new String[0]).command(infoArgs).start();
            infoStream = infoProcess.getInputStream();
            byte[] infoData = IOUtils.readFully((InputStream)infoStream, (int)-1, (boolean)false);
            if (infoData == null || infoData.length == 0) {
                throw new NullPointerException("The YT-DL playlist process resulted in a null or zero-length INFO!");
            }
            String sInfo = new String(infoData);
            scan = new Scanner(sInfo);
            JSONObject source = new JSONObject(scan.nextLine());
            if (source.has("_type")) {
                sources.add(new RemoteSource(source.getString("url")));
                while (scan.hasNextLine()) {
                    source = new JSONObject(scan.nextLine());
                    sources.add(new RemoteSource(source.getString("url")));
                }
            } else {
                sources.add(new RemoteSource(source.getString("webpage_url")));
            }
        }
        catch (IOException e) {
            AbstractMusicPlayer.LOG.log(e);
        }
        finally {
            try {
                if (scan != null) {
                    scan.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (infoProcess != null) {
                    infoProcess.destroyForcibly();
                }
            }
            catch (Throwable e) {}
            try {
                if (infoStream != null) {
                    infoStream.close();
                }
            }
            catch (Throwable e) {}
        }
        Playlist playlist = new Playlist("New Playlist");
        playlist.sources = sources;
        return playlist;
    }
}

