/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player;

import java.io.IOException;
import java.util.Arrays;
import net.dv8tion.jda.audio.AudioSendHandler;
import net.dv8tion.jda.player.AbstractMusicPlayer;

public class MusicPlayer
extends AbstractMusicPlayer
implements AudioSendHandler {
    public static final int PCM_FRAME_SIZE = 4;
    private byte[] buffer = new byte[3840];

    @Override
    public boolean canProvide() {
        return this.state.equals((Object)AbstractMusicPlayer.State.PLAYING);
    }

    @Override
    public byte[] provide20MsAudio() {
        try {
            int amountRead = this.currentAudioStream.read(this.buffer, 0, this.buffer.length);
            if (amountRead > -1) {
                if (amountRead < this.buffer.length) {
                    Arrays.fill(this.buffer, amountRead, this.buffer.length - 1, (byte)0);
                }
                if (this.volume != 1.0f) {
                    for (int i = 0; i < this.buffer.length; i += 2) {
                        short sample = (short)(this.buffer[i + 1] & 0xFF | this.buffer[i] << 8);
                        sample = (short)((float)sample * this.volume);
                        this.buffer[i + 1] = (byte)(sample & 0xFF);
                        this.buffer[i] = (byte)(sample >> 8 & 0xFF);
                    }
                }
                return this.buffer;
            }
            this.sourceFinished();
            return null;
        }
        catch (IOException e) {
            LOG.debug("A source closed unexpectantly? Oh well I guess...");
            this.sourceFinished();
            return null;
        }
    }
}

