/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.JDABuilder;
import net.dv8tion.jda.MessageBuilder;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.events.message.guild.GuildMessageReceivedEvent;
import net.dv8tion.jda.hooks.ListenerAdapter;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.player.MusicPlayer;
import net.dv8tion.jda.player.Playlist;
import net.dv8tion.jda.player.source.AudioInfo;
import net.dv8tion.jda.player.source.AudioSource;
import net.dv8tion.jda.player.source.AudioTimestamp;
import org.json.JSONException;
import org.json.JSONObject;

public class Bot
extends ListenerAdapter {
    public static final float DEFAULT_VOLUME = 0.35f;

    public static void main(String[] args) {
        try {
            JSONObject obj = new JSONObject(new String(Files.readAllBytes(Paths.get("Config.json", new String[0]))));
            JDA jDA = new JDABuilder().setBotToken(obj.getString("botToken")).addListener(new Bot()).buildBlocking();
        }
        catch (IllegalArgumentException e) {
            System.out.println("The config was not populated. Please provide a token.");
        }
        catch (LoginException e) {
            System.out.println("The provided botToken was incorrect. Please provide valid details.");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            System.err.println("Encountered a JSON error. Most likely caused due to an outdated or ill-formated config.\nPlease delete the config so that it can be regenerated. JSON Error:\n");
            e.printStackTrace();
        }
        catch (IOException e) {
            JSONObject obj = new JSONObject();
            obj.put("botToken", "");
            try {
                Files.write(Paths.get("Config.json", new String[0]), obj.toString(4).getBytes(), new OpenOption[0]);
                System.out.println("No config file was found. Config.json has been generated, please populate it!");
            }
            catch (IOException e1) {
                System.out.println("No config file was found and we failed to generate one.");
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void onGuildMessageReceived(final GuildMessageReceivedEvent event) {
        MusicPlayer player;
        try {
            if (!Files.readAllLines(Paths.get("admins.txt", new String[0])).contains(event.getAuthor().getId())) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String message = event.getMessage().getContent();
        AudioManager manager = event.getGuild().getAudioManager();
        if (manager.getSendingHandler() == null) {
            player = new MusicPlayer();
            player.setVolume(0.35f);
            manager.setSendingHandler(player);
        } else {
            player = (MusicPlayer)manager.getSendingHandler();
        }
        if (message.startsWith("volume ")) {
            float volume = Float.parseFloat(message.substring("volume ".length()));
            volume = Math.min(1.0f, Math.max(0.0f, volume));
            player.setVolume(volume);
            event.getChannel().sendMessage("Volume was changed to: " + volume);
        }
        if (message.equals("list")) {
            LinkedList<AudioSource> queue = player.getAudioQueue();
            if (queue.isEmpty()) {
                event.getChannel().sendMessage("The queue is currently empty!");
                return;
            }
            MessageBuilder builder = new MessageBuilder();
            builder.appendString("__Current Queue.  Entries: " + queue.size() + "__\n");
            for (int i = 0; i < queue.size() && i < 10; ++i) {
                AudioInfo info = ((AudioSource)queue.get(i)).getInfo();
                if (info == null) {
                    builder.appendString("*Could not get info for this song.*");
                    continue;
                }
                AudioTimestamp duration = info.getDuration();
                builder.appendString("`[");
                if (duration == null) {
                    builder.appendString("N/A");
                } else {
                    builder.appendString(duration.getTimestamp());
                }
                builder.appendString("]` " + info.getTitle() + "\n");
            }
            boolean error = false;
            int totalSeconds = 0;
            for (AudioSource source : queue) {
                AudioInfo info = source.getInfo();
                if (info == null || info.getDuration() == null) {
                    error = true;
                    continue;
                }
                totalSeconds += info.getDuration().getTotalSeconds();
            }
            builder.appendString("\nTotal Queue Time Length: " + AudioTimestamp.fromSeconds(totalSeconds).getTimestamp());
            if (error) {
                builder.appendString("`An error occured calculating total time. Might not be completely valid.");
            }
            event.getChannel().sendMessage(builder.build());
        }
        if (message.equals("nowplaying")) {
            if (player.isPlaying()) {
                AudioTimestamp currentTime = player.getCurrentTimestamp();
                AudioInfo info = player.getCurrentAudioSource().getInfo();
                if (info.getError() == null) {
                    event.getChannel().sendMessage("**Playing:** " + info.getTitle() + "\n" + "**Time:**    [" + currentTime.getTimestamp() + " / " + info.getDuration().getTimestamp() + "]");
                } else {
                    event.getChannel().sendMessage("**Playing:** Info Error. Known source: " + player.getCurrentAudioSource().getSource() + "\n" + "**Time:**    [" + currentTime.getTimestamp() + " / (N/A)]");
                }
            } else {
                event.getChannel().sendMessage("The player is not currently playing anything!");
            }
        }
        if (message.startsWith("join ")) {
            String chanName = message.substring(5);
            VoiceChannel channel = event.getGuild().getVoiceChannels().stream().filter(vChan -> vChan.getName().equalsIgnoreCase(chanName)).findFirst().orElse(null);
            if (channel == null) {
                event.getChannel().sendMessage("There isn't a VoiceChannel in this Guild with the name: '" + chanName + "'");
                return;
            }
            manager.openAudioConnection(channel);
        }
        if (message.equals("leave")) {
            manager.closeAudioConnection();
        }
        if (message.equals("skip")) {
            player.skipToNext();
            event.getChannel().sendMessage("Skipped the current song.");
        }
        if (message.equals("repeat")) {
            if (player.isRepeat()) {
                player.setRepeat(false);
                event.getChannel().sendMessage("The player has been set to **not** repeat.");
            } else {
                player.setRepeat(true);
                event.getChannel().sendMessage("The player been set to repeat.");
            }
        }
        if (message.equals("shuffle")) {
            if (player.isShuffle()) {
                player.setShuffle(false);
                event.getChannel().sendMessage("The player has been set to **not** shuffle.");
            } else {
                player.setShuffle(true);
                event.getChannel().sendMessage("The player been set to shuffle.");
            }
        }
        if (message.equals("reset")) {
            player.stop();
            player = new MusicPlayer();
            player.setVolume(0.35f);
            manager.setSendingHandler(player);
            event.getChannel().sendMessage("Music player has been completely reset.");
        }
        if (message.startsWith("play")) {
            if (message.equals("play")) {
                if (player.isPlaying()) {
                    event.getChannel().sendMessage("Player is already playing!");
                    return;
                }
                if (player.isPaused()) {
                    player.play();
                    event.getChannel().sendMessage("Playback as been resumed.");
                } else if (player.getAudioQueue().isEmpty()) {
                    event.getChannel().sendMessage("The current audio queue is empty! Add something to the queue first!");
                } else {
                    player.play();
                    event.getChannel().sendMessage("Player has started playing!");
                }
            } else if (message.startsWith("play ")) {
                String msg = "";
                String url = message.substring("play ".length());
                Playlist playlist = Playlist.getPlaylist(url);
                final LinkedList<AudioSource> sources = new LinkedList<AudioSource>(playlist.getSources());
                if (sources.size() > 1) {
                    event.getChannel().sendMessage("Found a playlist with **" + sources.size() + "** entries.\n" + "Proceeding to gather information and queue sources. This may take some time...");
                    final MusicPlayer fPlayer = player;
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            Iterator it = sources.iterator();
                            while (it.hasNext()) {
                                AudioSource source = (AudioSource)it.next();
                                AudioInfo info = source.getInfo();
                                LinkedList<AudioSource> queue = fPlayer.getAudioQueue();
                                if (info.getError() == null) {
                                    queue.add(source);
                                    if (!fPlayer.isStopped()) continue;
                                    fPlayer.play();
                                    continue;
                                }
                                event.getChannel().sendMessage("Error detected, skipping source. Error:\n" + info.getError());
                                it.remove();
                            }
                            event.getChannel().sendMessage("Finished queuing provided playlist. Successfully queued **" + sources.size() + "** sources");
                        }
                    };
                    thread.start();
                } else {
                    AudioSource source = (AudioSource)sources.get(0);
                    AudioInfo info = source.getInfo();
                    if (info.getError() == null) {
                        player.getAudioQueue().add(source);
                        msg = msg + "The provided URL has been added the to queue";
                        if (player.isStopped()) {
                            player.play();
                            msg = msg + " and the player has started playing";
                        }
                        event.getChannel().sendMessage(msg + ".");
                    } else {
                        event.getChannel().sendMessage("There was an error while loading the provided URL.\nError: " + info.getError());
                    }
                }
            }
        }
        if (message.equals("pause")) {
            player.pause();
            event.getChannel().sendMessage("Playback has been paused.");
        }
        if (message.equals("stop")) {
            player.stop();
            event.getChannel().sendMessage("Playback has been completely stopped.");
        }
        if (message.equals("restart")) {
            if (player.isStopped()) {
                if (player.getPreviousAudioSource() != null) {
                    player.reload(true);
                    event.getChannel().sendMessage("The previous song has been restarted.");
                } else {
                    event.getChannel().sendMessage("The player has never played a song, so it cannot restart a song.");
                }
            } else {
                player.reload(true);
                event.getChannel().sendMessage("The currently playing song has been restarted!");
            }
        }
    }
}

