/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.player;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.dv8tion.jda.player.PlayerLog;
import net.dv8tion.jda.player.hooks.PlayerEventListener;
import net.dv8tion.jda.player.hooks.PlayerEventManager;
import net.dv8tion.jda.player.hooks.events.FinishEvent;
import net.dv8tion.jda.player.hooks.events.NextEvent;
import net.dv8tion.jda.player.hooks.events.PauseEvent;
import net.dv8tion.jda.player.hooks.events.PlayEvent;
import net.dv8tion.jda.player.hooks.events.ReloadEvent;
import net.dv8tion.jda.player.hooks.events.RepeatEvent;
import net.dv8tion.jda.player.hooks.events.SkipEvent;
import net.dv8tion.jda.player.hooks.events.StopEvent;
import net.dv8tion.jda.player.source.AudioSource;
import net.dv8tion.jda.player.source.AudioStream;
import net.dv8tion.jda.player.source.AudioTimestamp;

public abstract class AbstractMusicPlayer {
    public static final PlayerLog LOG = PlayerLog.getLog("JDAPlayer");
    protected PlayerEventManager eventManager = new PlayerEventManager();
    protected LinkedList<AudioSource> audioQueue = new LinkedList();
    protected AudioSource previousAudioSource = null;
    protected AudioSource currentAudioSource = null;
    protected AudioStream currentAudioStream = null;
    protected State state = State.STOPPED;
    protected boolean autoContinue = true;
    protected boolean shuffle = false;
    protected boolean repeat = false;
    protected float volume = 1.0f;

    public void addEventListener(PlayerEventListener listener) {
        this.eventManager.register(listener);
    }

    public void removeEventListener(PlayerEventListener listener) {
        this.eventManager.unregister(listener);
    }

    public List<PlayerEventListener> getListeners() {
        return this.eventManager.getListeners();
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public void reload(boolean autoPlay) {
        this.reload0(autoPlay, true);
    }

    public void skipToNext() {
        AudioSource skipped = this.currentAudioSource;
        this.playNext(false);
        this.eventManager.handle(new SkipEvent(this, skipped));
        if (this.state == State.STOPPED) {
            this.eventManager.handle(new FinishEvent(this));
        }
    }

    public LinkedList<AudioSource> getAudioQueue() {
        return this.audioQueue;
    }

    public AudioSource getCurrentAudioSource() {
        return this.currentAudioSource;
    }

    public AudioSource getPreviousAudioSource() {
        return this.previousAudioSource;
    }

    public AudioTimestamp getCurrentTimestamp() {
        if (this.currentAudioStream != null) {
            return this.currentAudioStream.getCurrentTimestamp();
        }
        return null;
    }

    public void play() {
        this.play0(true);
    }

    public void pause() {
        if (this.state == State.PAUSED) {
            return;
        }
        if (this.state == State.STOPPED) {
            throw new IllegalStateException("Cannot pause a stopped player!");
        }
        this.state = State.PAUSED;
        this.eventManager.handle(new PauseEvent(this));
    }

    public void stop() {
        this.stop0(true);
    }

    public boolean isPlaying() {
        return this.state == State.PLAYING;
    }

    public boolean isPaused() {
        return this.state == State.PAUSED;
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    protected void play0(boolean fireEvent) {
        if (this.state == State.PLAYING) {
            return;
        }
        if (this.currentAudioSource != null) {
            this.state = State.PLAYING;
            if (fireEvent) {
                this.eventManager.handle(new PlayEvent(this));
            }
            return;
        }
        if (this.audioQueue.isEmpty()) {
            throw new IllegalStateException("MusicPlayer: The audio queue is empty! Cannot start playing.");
        }
        this.loadFromSource(this.audioQueue.removeFirst());
        this.state = State.PLAYING;
        if (fireEvent) {
            this.eventManager.handle(new PlayEvent(this));
        }
    }

    protected void stop0(boolean fireEvent) {
        if (this.state == State.STOPPED) {
            return;
        }
        this.state = State.STOPPED;
        try {
            this.currentAudioStream.close();
        }
        catch (IOException e) {
            LOG.log(e);
        }
        finally {
            this.previousAudioSource = this.currentAudioSource;
            this.currentAudioSource = null;
            this.currentAudioStream = null;
        }
        if (fireEvent) {
            this.eventManager.handle(new StopEvent(this));
        }
    }

    protected void reload0(boolean autoPlay, boolean fireEvent) {
        if (this.previousAudioSource == null && this.currentAudioSource == null) {
            throw new IllegalStateException("Cannot restart or reload a player that has never been started!");
        }
        this.stop0(false);
        this.loadFromSource(this.previousAudioSource);
        if (autoPlay) {
            this.play0(false);
        }
        if (fireEvent) {
            this.eventManager.handle(new ReloadEvent(this));
        }
    }

    protected void playNext(boolean fireEvent) {
        AudioSource source;
        this.stop0(false);
        if (this.audioQueue.isEmpty()) {
            if (fireEvent) {
                this.eventManager.handle(new FinishEvent(this));
            }
            return;
        }
        if (this.shuffle) {
            Random rand = new Random();
            source = this.audioQueue.remove(rand.nextInt(this.audioQueue.size()));
        } else {
            source = this.audioQueue.removeFirst();
        }
        this.loadFromSource(source);
        this.play0(false);
        if (fireEvent) {
            this.eventManager.handle(new NextEvent(this));
        }
    }

    protected void sourceFinished() {
        if (this.autoContinue) {
            if (this.repeat) {
                this.reload0(true, false);
                this.eventManager.handle(new RepeatEvent(this));
            } else {
                this.playNext(true);
            }
        } else {
            this.stop0(true);
        }
    }

    protected void loadFromSource(AudioSource source) {
        AudioStream stream = source.asStream();
        this.currentAudioSource = source;
        this.currentAudioStream = stream;
    }

    protected static enum State {
        PLAYING,
        PAUSED,
        STOPPED;

    }
}

