/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.managers;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.Region;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.VoiceStatus;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.exceptions.GuildUnavailableException;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.requests.Requester;
import net.dv8tion.jda.utils.AvatarUtil;
import net.dv8tion.jda.utils.PermissionUtil;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildManager {
    private final Guild guild;
    private Timeout timeout = null;
    private String name = null;
    private Region region = null;
    private AvatarUtil.Avatar icon = null;
    private Guild.VerificationLevel verificationLevel = null;
    private String afkChannelId;
    private final Map<User, Set<Role>> addedRoles = new HashMap<User, Set<Role>>();
    private final Map<User, Set<Role>> removedRoles = new HashMap<User, Set<Role>>();

    public GuildManager(Guild guild) {
        if (!guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.guild = guild;
        this.afkChannelId = guild.getAfkChannelId();
    }

    public Guild getGuild() {
        return this.guild;
    }

    public GuildManager setName(String name) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_SERVER);
        this.name = this.guild.getName().equals(name) ? null : name;
        return this;
    }

    public GuildManager setRegion(Region region) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_SERVER);
        this.region = region == this.guild.getRegion() || region == Region.UNKNOWN ? null : region;
        return this;
    }

    public GuildManager setIcon(AvatarUtil.Avatar avatar) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_SERVER);
        this.icon = avatar;
        return this;
    }

    public GuildManager setAfkChannel(VoiceChannel channel) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_SERVER);
        if (channel != null && channel.getGuild() != this.guild) {
            throw new IllegalArgumentException("Given VoiceChannel is not member of modifying Guild");
        }
        this.afkChannelId = channel == null ? null : channel.getId();
        return this;
    }

    public GuildManager setAfkTimeout(Timeout timeout) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_SERVER);
        this.timeout = timeout;
        return this;
    }

    public GuildManager addRoleToUser(User user, Role ... roles) {
        Set<Role> removeRoles;
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_ROLES);
        for (Role role : roles) {
            this.checkPosition(role);
        }
        Set<Role> addRoles = this.addedRoles.get(user);
        if (addRoles == null) {
            addRoles = new HashSet<Role>();
            this.addedRoles.put(user, addRoles);
        }
        if ((removeRoles = this.removedRoles.get(user)) == null) {
            removeRoles = new HashSet<Role>();
            this.removedRoles.put(user, removeRoles);
        }
        for (Role role : roles) {
            if (this.guild.getPublicRole().equals(role)) {
                return this;
            }
            if (removeRoles.contains(role)) {
                removeRoles.remove(role);
            }
            addRoles.add(role);
        }
        return this;
    }

    public GuildManager removeRoleFromUser(User user, Role ... roles) {
        Set<Role> removeRoles;
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_ROLES);
        for (Role role : roles) {
            this.checkPosition(role);
        }
        Set<Role> addRoles = this.addedRoles.get(user);
        if (addRoles == null) {
            addRoles = new HashSet<Role>();
            this.addedRoles.put(user, addRoles);
        }
        if ((removeRoles = this.removedRoles.get(user)) == null) {
            removeRoles = new HashSet<Role>();
            this.removedRoles.put(user, removeRoles);
        }
        for (Role role : roles) {
            if (this.guild.getPublicRole().equals(role)) {
                return this;
            }
            if (addRoles.contains(role)) {
                addRoles.remove(role);
            }
            removeRoles.add(role);
        }
        return this;
    }

    public GuildManager setVerificationLevel(Guild.VerificationLevel level) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.MANAGE_SERVER);
        this.verificationLevel = this.guild.getVerificationLevel() == level ? null : level;
        return this;
    }

    public void reset() {
        this.name = null;
        this.region = null;
        this.timeout = null;
        this.icon = null;
        this.verificationLevel = null;
        this.afkChannelId = this.guild.getAfkChannelId();
        this.addedRoles.clear();
        this.removedRoles.clear();
    }

    public void update() {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        if (this.name != null || this.region != null || this.timeout != null || this.icon != null || !StringUtils.equals(this.afkChannelId, this.guild.getAfkChannelId()) || this.verificationLevel != null) {
            this.checkPermission(Permission.MANAGE_SERVER);
            JSONObject frame = this.getFrame();
            if (this.name != null) {
                frame.put("name", this.name);
            }
            if (this.region != null) {
                frame.put("region", this.region.getKey());
            }
            if (this.timeout != null) {
                frame.put("afk_timeout", this.timeout.getSeconds());
            }
            if (this.icon != null) {
                frame.put("icon", this.icon == AvatarUtil.DELETE_AVATAR ? JSONObject.NULL : this.icon.getEncoded());
            }
            if (!StringUtils.equals(this.afkChannelId, this.guild.getAfkChannelId())) {
                frame.put("afk_channel_id", this.afkChannelId == null ? JSONObject.NULL : this.afkChannelId);
            }
            if (this.verificationLevel != null) {
                frame.put("verification_level", this.verificationLevel.getKey());
            }
            this.update(frame);
        }
        if (this.addedRoles.size() > 0) {
            this.checkPermission(Permission.MANAGE_ROLES);
            for (User user : this.addedRoles.keySet()) {
                List<Role> roles = this.guild.getRolesForUser(user);
                LinkedList roleIds = new LinkedList();
                roles.forEach(r -> roleIds.add(r.getId()));
                this.addedRoles.get(user).stream().filter(role -> !roleIds.contains(role.getId())).forEach(role -> roleIds.add(role.getId()));
                this.removedRoles.get(user).stream().filter(role -> roleIds.contains(role.getId())).forEach(role -> roleIds.remove(role.getId()));
                ((JDAImpl)this.guild.getJDA()).getRequester().patch("https://discordapp.com/api/guilds/" + this.guild.getId() + "/members/" + user.getId(), new JSONObject().put("roles", (Object)roleIds));
            }
            this.addedRoles.clear();
            this.removedRoles.clear();
        }
    }

    public void setNickname(User user, String nickname) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        if (user == this.guild.getJDA().getSelfInfo()) {
            if (!PermissionUtil.checkPermission(user, Permission.NICKNAME_CHANGE, this.guild) && !PermissionUtil.checkPermission(user, Permission.NICKNAME_MANAGE, this.guild)) {
                throw new PermissionException(Permission.NICKNAME_CHANGE, "You neither have NICKNAME_CHANGE nor NICKNAME_MANAGE permission!");
            }
        } else {
            this.checkPermission(Permission.NICKNAME_MANAGE);
            this.checkPosition(user);
        }
        if (nickname == null) {
            nickname = "";
        }
        String url = "https://discordapp.com/api/guilds/" + this.guild.getId() + "/members/" + (user == this.guild.getJDA().getSelfInfo() ? "@me/nick" : user.getId());
        ((JDAImpl)this.guild.getJDA()).getRequester().patch(url, new JSONObject().put("nick", nickname));
    }

    public void moveVoiceUser(User user, VoiceChannel voiceChannel) {
        if (user == null) {
            throw new IllegalArgumentException("Provided User was null. Cannot determine which User to move when User is null!");
        }
        if (voiceChannel == null) {
            throw new IllegalArgumentException("Provided VoiceChannel was null. Cannot determine which channel to move the User to because VoiceChannel is null!");
        }
        if (!voiceChannel.getGuild().getId().equals(this.guild.getId())) {
            throw new IllegalArgumentException("Cannot move a User to a VoiceChannel that isn't part of this Guild!");
        }
        VoiceStatus status = this.guild.getVoiceStatusOfUser(user);
        if (!status.inVoiceChannel()) {
            throw new IllegalStateException("You cannot move a User who isn't in a VoiceChannel!");
        }
        if (!PermissionUtil.checkPermission((User)this.guild.getJDA().getSelfInfo(), Permission.VOICE_MOVE_OTHERS, status.getChannel())) {
            throw new PermissionException(Permission.VOICE_MOVE_OTHERS, "This account does not have Permission to MOVE_OTHERS from the currently VoiceChannel");
        }
        if (!PermissionUtil.checkPermission((User)this.guild.getJDA().getSelfInfo(), Permission.VOICE_CONNECT, voiceChannel) && !PermissionUtil.checkPermission(user, Permission.VOICE_CONNECT, voiceChannel)) {
            throw new PermissionException(Permission.VOICE_CONNECT, "Neither this account nor the User that is attempting to be moved have the VOICE_CONNECT permission for the destination VoiceChannel, so the move cannot be done.");
        }
        ((JDAImpl)this.guild.getJDA()).getRequester().patch("https://discordapp.com/api/guilds/" + this.guild.getId() + "/members/" + user.getId(), new JSONObject().put("channel_id", voiceChannel.getId()));
    }

    public int prune(int days, boolean doKick) {
        if (!PermissionUtil.checkPermission((User)this.guild.getJDA().getSelfInfo(), Permission.KICK_MEMBERS, this.guild)) {
            throw new PermissionException(Permission.KICK_MEMBERS);
        }
        JSONObject returned = doKick ? ((JDAImpl)this.guild.getJDA()).getRequester().post("https://discordapp.com/api/guilds/" + this.guild.getId() + "/prune?days=" + days, new JSONObject()).getObject() : ((JDAImpl)this.guild.getJDA()).getRequester().get("https://discordapp.com/api/guilds/" + this.guild.getId() + "/prune?days=" + days).getObject();
        return returned.getInt("pruned");
    }

    public void kick(User user) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.KICK_MEMBERS);
        this.checkPosition(user);
        ((JDAImpl)this.guild.getJDA()).getRequester().delete("https://discordapp.com/api/guilds/" + this.guild.getId() + "/members/" + user.getId());
    }

    public void kick(String userId) {
        User user = this.guild.getJDA().getUserById(userId);
        if (user != null) {
            this.kick(user);
        }
    }

    public void ban(User user, int delDays) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.BAN_MEMBERS);
        if (this.guild.getUsers().contains(user)) {
            this.checkPosition(user);
        }
        ((JDAImpl)this.guild.getJDA()).getRequester().put("https://discordapp.com/api/guilds/" + this.guild.getId() + "/bans/" + user.getId() + (delDays > 0 ? "?delete-message-days=" + delDays : ""), new JSONObject());
    }

    public void ban(String userId, int delDays) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        User user = this.guild.getJDA().getUserById(userId);
        if (user != null) {
            this.ban(user, delDays);
            return;
        }
        this.checkPermission(Permission.BAN_MEMBERS);
        Requester.Response response = ((JDAImpl)this.guild.getJDA()).getRequester().put("https://discordapp.com/api/guilds/" + this.guild.getId() + "/bans/" + userId + (delDays > 0 ? "?delete-message-days=" + delDays : ""), new JSONObject());
        if (response.isOk()) {
            return;
        }
        if (response.code == 404) {
            throw new IllegalArgumentException("User with id \"" + userId + "\" does not exist.");
        }
        JDAImpl.LOG.fatal("Something went wrong trying to ban a user by id: " + response.toString());
    }

    public void deafen(User user) {
        this.deafen(user, true);
    }

    public void mute(User user) {
        this.mute(user, true);
    }

    public List<User> getBans() {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.BAN_MEMBERS);
        LinkedList<User> bans = new LinkedList<User>();
        JSONArray bannedArr = ((JDAImpl)this.guild.getJDA()).getRequester().get("https://discordapp.com/api/guilds/" + this.guild.getId() + "/bans").getArray();
        for (int i = 0; i < bannedArr.length(); ++i) {
            JSONObject userObj = bannedArr.getJSONObject(i).getJSONObject("user");
            User u = this.guild.getJDA().getUserById(userObj.getString("id"));
            if (u != null) {
                bans.add(u);
                continue;
            }
            bans.add(new UserImpl(userObj.getString("id"), (JDAImpl)this.guild.getJDA()).setUserName(userObj.getString("username")).setDiscriminator(userObj.get("discriminator").toString()).setAvatarId(userObj.isNull("avatar") ? null : userObj.getString("avatar")));
        }
        return Collections.unmodifiableList(bans);
    }

    public void unBan(User user) {
        this.unBan(user.getId());
    }

    public void unBan(String userId) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.BAN_MEMBERS);
        ((JDAImpl)this.guild.getJDA()).getRequester().delete("https://discordapp.com/api/guilds/" + this.guild.getId() + "/bans/" + userId);
    }

    public void undeafen(User user) {
        this.deafen(user, false);
    }

    public void unmute(User user) {
        this.mute(user, false);
    }

    public void leave() {
        if (this.guild.getJDA().getSelfInfo().getId().equals(this.guild.getOwnerId())) {
            throw new PermissionException("You can not leave a guild as the Guild-Owner. Use GuildManager#transferOwnership first, or use GuildManager#delete()");
        }
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        ((JDAImpl)this.guild.getJDA()).getRequester().delete("https://discordapp.com/api/users/@me/guilds/" + this.guild.getId());
    }

    private void deafen(User user, boolean deafen) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.VOICE_DEAF_OTHERS);
        String url = "https://discordapp.com/api/guilds/" + this.guild.getId() + "/members/" + user.getId();
        ((JDAImpl)this.guild.getJDA()).getRequester().patch(url, new JSONObject().put("deaf", deafen));
    }

    private void mute(User user, boolean mute) {
        if (!this.guild.isAvailable()) {
            throw new GuildUnavailableException();
        }
        this.checkPermission(Permission.VOICE_MUTE_OTHERS);
        String url = "https://discordapp.com/api/guilds/" + this.guild.getId() + "/members/" + user.getId();
        ((JDAImpl)this.guild.getJDA()).getRequester().patch(url, new JSONObject().put("mute", mute));
    }

    private JSONObject getFrame() {
        return new JSONObject().put("name", this.guild.getName());
    }

    private void update(JSONObject object) {
        ((JDAImpl)this.guild.getJDA()).getRequester().patch("https://discordapp.com/api/guilds/" + this.guild.getId(), object);
    }

    private void checkPermission(Permission perm) {
        if (!PermissionUtil.checkPermission((User)this.getGuild().getJDA().getSelfInfo(), perm, this.getGuild())) {
            throw new PermissionException(perm);
        }
    }

    private void checkPosition(User u) {
        if (!PermissionUtil.canInteract(this.guild.getJDA().getSelfInfo(), u, this.guild)) {
            throw new PermissionException("Can't modify a user with higher or equal highest role than yourself!");
        }
    }

    private void checkPosition(Role r) {
        if (!PermissionUtil.canInteract(this.guild.getJDA().getSelfInfo(), r)) {
            throw new PermissionException("Can't modify a user with higher or equal highest role than yourself!");
        }
    }

    static enum Timeout {
        SECONDS_60(60),
        SECONDS_300(300),
        SECONDS_900(900),
        SECONDS_1800(1800),
        SECONDS_3600(3600);

        private final int seconds;

        private Timeout(int seconds) {
            this.seconds = seconds;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public String toString() {
            return "" + this.seconds;
        }
    }
}

