/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.audio.AudioConnection;
import net.dv8tion.jda.audio.AudioWebSocket;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.requests.GuildLock;
import net.dv8tion.jda.requests.WebSocketClient;
import org.json.JSONObject;

public class VoiceServerUpdateHandler
extends SocketHandler {
    public VoiceServerUpdateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        String endpoint = content.getString("endpoint");
        String token = content.getString("token");
        Guild guild = this.api.getGuildMap().get(content.getString("guild_id"));
        if (guild == null) {
            throw new IllegalArgumentException("Attempted to start audio connection with Guild that doesn't exist! JSON: " + content);
        }
        String sessionId = guild.getVoiceStatusOfUser(this.api.getSelfInfo()).getSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Attempted to create audio connection without having a session ID. Did VOICE_STATE_UPDATED fail?");
        }
        endpoint = endpoint.replace(":80", "");
        AudioManagerImpl audioManager = (AudioManagerImpl)guild.getAudioManager();
        if (audioManager.isConnected()) {
            audioManager.prepareForRegionChange();
        }
        if (!audioManager.isAttemptingToConnect()) {
            WebSocketClient.LOG.debug("Received a VOICE_SERVER_UPDATE but JDA is not currently connected nor attempted to connect to a VoiceChannel. Assuming that this is caused by another client running on this account. Ignoring the event.");
            return null;
        }
        AudioWebSocket socket = new AudioWebSocket(endpoint, this.api, guild, sessionId, token);
        AudioConnection connection = new AudioConnection(socket, audioManager.getQueuedAudioConnection());
        audioManager.setAudioConnection(connection);
        return null;
    }
}

