/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.entities.impl.VoiceStatusImpl;
import net.dv8tion.jda.events.voice.VoiceJoinEvent;
import net.dv8tion.jda.events.voice.VoiceLeaveEvent;
import net.dv8tion.jda.events.voice.VoiceSelfDeafEvent;
import net.dv8tion.jda.events.voice.VoiceSelfMuteEvent;
import net.dv8tion.jda.events.voice.VoiceServerDeafEvent;
import net.dv8tion.jda.events.voice.VoiceServerMuteEvent;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class VoiceChangeHandler
extends SocketHandler {
    public VoiceChangeHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        boolean isSelfDeaf;
        boolean isSelfMute;
        VoiceChannel oldChannel;
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        User user = this.api.getUserMap().get(content.getString("user_id"));
        if (user == null) {
            if (!content.isNull("channel_id")) {
                EventCache.get(this.api).cache(EventCache.Type.USER, content.getString("user_id"), () -> this.handle(this.allContent));
                EventCache.LOG.debug("Received a VOICE_STATE_UPDATE for an unknown User! JSON: " + content);
                return null;
            }
            return null;
        }
        Guild guild = this.api.getGuildMap().get(content.getString("guild_id"));
        if (guild == null) {
            EventCache.get(this.api).cache(EventCache.Type.GUILD, content.getString("guild_id"), () -> this.handle(this.allContent));
            EventCache.LOG.debug("Received a VOICE_STATE_UPDATE for an unknown Guild! JSON: " + content);
            return null;
        }
        VoiceStatusImpl status = (VoiceStatusImpl)guild.getVoiceStatusOfUser(user);
        if (status == null) {
            return null;
        }
        if (content.isNull("channel_id")) {
            if (status.getChannel() != null && (oldChannel = status.getChannel()) != null) {
                status.setChannel(null);
                ((VoiceChannelImpl)oldChannel).getUsersModifiable().remove(user);
                this.api.getEventManager().handle(new VoiceLeaveEvent(this.api, this.responseNumber, status, oldChannel));
            }
        } else if (status.getChannel() == null || !content.getString("channel_id").equals(status.getChannel().getId())) {
            oldChannel = status.getChannel();
            VoiceChannel newChannel = this.api.getVoiceChannelMap().get(content.getString("channel_id"));
            if (newChannel == null) {
                EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("channel_id"), () -> this.handle(this.allContent));
                EventCache.LOG.debug("Received a VOICE_STATE_CHANGE for an unknown Channel! JSON: " + content);
                return null;
            }
            status.setChannel(newChannel);
            if (oldChannel != null) {
                ((VoiceChannelImpl)oldChannel).getUsersModifiable().remove(user);
                this.api.getEventManager().handle(new VoiceLeaveEvent(this.api, this.responseNumber, status, oldChannel));
            }
            ((VoiceChannelImpl)newChannel).getUsersModifiable().add(user);
            this.api.getEventManager().handle(new VoiceJoinEvent(this.api, this.responseNumber, status));
        }
        if (!content.isNull("session_id")) {
            status.setSessionId(content.getString("session_id"));
        } else {
            status.setSessionId(null);
        }
        status.setSuppressed(content.getBoolean("suppress"));
        boolean bl = isSelfMute = !content.isNull("self_mute") && content.getBoolean("self_mute");
        if (isSelfMute != status.isMuted()) {
            status.setMute(!status.isMuted());
            this.api.getEventManager().handle(new VoiceSelfMuteEvent(this.api, this.responseNumber, status));
        }
        boolean bl2 = isSelfDeaf = !content.isNull("self_deaf") && content.getBoolean("self_deaf");
        if (isSelfDeaf != status.isDeaf()) {
            status.setDeaf(!status.isDeaf());
            this.api.getEventManager().handle(new VoiceSelfDeafEvent(this.api, this.responseNumber, status));
        }
        if (content.getBoolean("mute") != status.isServerMuted()) {
            status.setServerMute(!status.isServerMuted());
            this.api.getEventManager().handle(new VoiceServerMuteEvent(this.api, this.responseNumber, status));
        }
        if (content.getBoolean("deaf") != status.isServerDeaf()) {
            status.setServerDeaf(!status.isServerDeaf());
            this.api.getEventManager().handle(new VoiceServerDeafEvent(this.api, this.responseNumber, status));
        }
        return null;
    }
}

