/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import net.dv8tion.jda.entities.MessageChannel;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.user.GenericUserEvent;
import net.dv8tion.jda.events.user.UserTypingEvent;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class UserTypingHandler
extends SocketHandler {
    public UserTypingHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        MessageChannel channel = this.api.getChannelMap().get(content.getString("channel_id"));
        if (channel == null) {
            channel = this.api.getPmChannelMap().get(content.getString("channel_id"));
        } else if (GuildLock.get(this.api).isLocked(((TextChannel)channel).getGuild().getId())) {
            return ((TextChannel)channel).getGuild().getId();
        }
        User user = this.api.getUserMap().get(content.getString("user_id"));
        if (user == null) {
            return null;
        }
        OffsetDateTime timestamp = Instant.ofEpochSecond(content.getInt("timestamp")).atOffset(ZoneOffset.UTC);
        this.api.getEventManager().handle(new UserTypingEvent(this.api, this.responseNumber, user, channel, timestamp));
        this.api.getEventManager().handle(new GenericUserEvent(this.api, this.responseNumber, user));
        return null;
    }
}

