/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.OnlineStatus;
import net.dv8tion.jda.entities.ChannelType;
import net.dv8tion.jda.entities.Game;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.SocketHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReadyHandler
extends SocketHandler {
    private final EntityBuilder builder;
    private static Map<JDA, Set<String>> guildIds = new HashMap<JDA, Set<String>>();
    private static Map<JDA, Set<String>> chunkIds = new HashMap<JDA, Set<String>>();
    private static Map<JDA, JSONObject> cachedJson = new HashMap<JDA, JSONObject>();

    public ReadyHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
        this.builder = new EntityBuilder(api);
        if (!guildIds.containsKey(api)) {
            guildIds.put(api, new HashSet());
        }
        if (!chunkIds.containsKey(api)) {
            chunkIds.put(api, new HashSet());
        }
    }

    @Override
    protected String handleInternally(JSONObject content) {
        JSONArray guilds;
        Game oldGame = null;
        OnlineStatus oldStatus = null;
        if (this.api.getSelfInfo() != null) {
            oldGame = this.api.getSelfInfo().getCurrentGame();
            oldStatus = this.api.getSelfInfo().getOnlineStatus();
        }
        this.builder.createSelfInfo(content.getJSONObject("user"));
        if (oldGame != null) {
            if (oldGame.getType() == Game.GameType.DEFAULT) {
                this.api.getAccountManager().setGame(oldGame.getName());
            } else {
                this.api.getAccountManager().setStreaming(oldGame.getName(), oldGame.getUrl());
            }
        }
        if (oldStatus != null && oldStatus.equals((Object)OnlineStatus.AWAY)) {
            this.api.getAccountManager().setIdle(true);
        }
        if ((guilds = content.getJSONArray("guilds")).length() == 0) {
            this.finishReady(content);
        } else {
            cachedJson.put(this.api, content);
            Set<String> guildIds = ReadyHandler.guildIds.get(this.api);
            HashSet<JSONObject> guildJsons = new HashSet<JSONObject>();
            for (int i = 0; i < guilds.length(); ++i) {
                JSONObject guildJson = guilds.getJSONObject(i);
                guildIds.add(guildJson.getString("id"));
                guildJsons.add(guildJson);
            }
            for (JSONObject guildJson : guildJsons) {
                if (guildJson.has("unavailable") && guildJson.getBoolean("unavailable")) {
                    this.builder.createGuildFirstPass(guildJson, null);
                    continue;
                }
                this.builder.createGuildFirstPass(guildJson, this::onGuildInit);
            }
        }
        return null;
    }

    public void onGuildNeedsMembers(Guild g) {
        Set<String> chunks = chunkIds.get(this.api);
        chunks.add(g.getId());
        if (chunks.size() == guildIds.get(this.api).size()) {
            this.sendChunks();
        }
    }

    public void onGuildInit(Guild guild) {
        Set<String> ids = guildIds.get(this.api);
        ids.remove(guild.getId());
        if (ids.isEmpty()) {
            this.finishReady(cachedJson.get(this.api));
        } else if (ids.size() == chunkIds.get(this.api).size()) {
            this.sendChunks();
        }
    }

    public void finishReady(JSONObject content) {
        JSONArray priv_chats = content.getJSONArray("private_channels");
        for (int i = 0; i < priv_chats.length(); ++i) {
            JSONObject privateChannel = priv_chats.getJSONObject(i);
            ChannelType type = ChannelType.fromId(privateChannel.getInt("type"));
            if (type == ChannelType.PRIVATE) {
                this.builder.createPrivateChannel(privateChannel);
                continue;
            }
            if (type == ChannelType.GROUP) {
                JDAImpl.LOG.debug("Received a group channel in the READY packet, but GROUPS aren't supported by JDA (JDA-Client only)");
                continue;
            }
            JDAImpl.LOG.fatal("Received a private channel in the READY packet that is of an unknown type!");
        }
        this.api.getClient().ready();
    }

    public void clearCache() {
        guildIds.get(this.api).clear();
        chunkIds.get(this.api).clear();
        cachedJson.remove(this.api);
    }

    private void sendChunks() {
        JSONObject obj;
        Iterator<String> iterator = chunkIds.get(this.api).iterator();
        JSONArray arr = new JSONArray();
        while (iterator.hasNext()) {
            arr.put(iterator.next());
            if (arr.length() != 50) continue;
            obj = new JSONObject().put("op", 8).put("d", new JSONObject().put("guild_id", arr).put("query", "").put("limit", 0));
            this.api.getClient().send(obj.toString());
            arr = new JSONArray();
        }
        if (arr.length() > 0) {
            obj = new JSONObject().put("op", 8).put("d", new JSONObject().put("guild_id", arr).put("query", "").put("limit", 0));
            this.api.getClient().send(obj.toString());
        }
        chunkIds.get(this.api).clear();
    }
}

