/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.LinkedList;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.message.MessageBulkDeleteEvent;
import net.dv8tion.jda.handle.MessageDeleteHandler;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class MessageBulkDeleteHandler
extends SocketHandler {
    public MessageBulkDeleteHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String channelId = content.getString("channel_id");
        if (this.api.isBulkDeleteSplittingEnabled()) {
            content.getJSONArray("ids").forEach(id -> new MessageDeleteHandler(this.api, this.responseNumber).handle(new JSONObject().put("d", new JSONObject().put("channel_id", channelId).put("id", id))));
        } else {
            TextChannel channel = this.api.getChannelMap().get(channelId);
            if (channel != null) {
                if (GuildLock.get(this.api).isLocked(channel.getGuild().getId())) {
                    return channel.getGuild().getId();
                }
                LinkedList<String> msgIds = new LinkedList<String>();
                content.getJSONArray("ids").forEach(id -> msgIds.add((String)id));
                this.api.getEventManager().handle(new MessageBulkDeleteEvent(this.api, this.responseNumber, channel, msgIds));
            }
        }
        return null;
    }
}

