/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.RoleImpl;
import net.dv8tion.jda.events.guild.role.GuildRoleUpdateColorEvent;
import net.dv8tion.jda.events.guild.role.GuildRoleUpdateEvent;
import net.dv8tion.jda.events.guild.role.GuildRoleUpdateGroupedEvent;
import net.dv8tion.jda.events.guild.role.GuildRoleUpdateNameEvent;
import net.dv8tion.jda.events.guild.role.GuildRoleUpdatePermissionEvent;
import net.dv8tion.jda.events.guild.role.GuildRoleUpdatePositionEvent;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class GuildRoleUpdateHandler
extends SocketHandler {
    public GuildRoleUpdateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        JSONObject rolejson = content.getJSONObject("role");
        RoleImpl role = (RoleImpl)((GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"))).getRolesMap().get(rolejson.getString("id"));
        if (role == null) {
            EventCache.get(this.api).cache(EventCache.Type.ROLE, rolejson.getString("id"), () -> this.handle(this.allContent));
            EventCache.LOG.debug("Received a Role Update for a non-existent role! JSON: " + content);
            return null;
        }
        if (!role.getName().equals(rolejson.getString("name"))) {
            role.setName(rolejson.getString("name"));
            this.api.getEventManager().handle(new GuildRoleUpdateNameEvent(this.api, this.responseNumber, role));
        }
        if (role.getPositionRaw() != rolejson.getInt("position")) {
            role.setPosition(rolejson.getInt("position"));
            this.api.getEventManager().handle(new GuildRoleUpdatePositionEvent(this.api, this.responseNumber, role));
        }
        if (role.getPermissionsRaw() != rolejson.getInt("permissions")) {
            role.setPermissions(rolejson.getInt("permissions"));
            this.api.getEventManager().handle(new GuildRoleUpdatePermissionEvent(this.api, this.responseNumber, role));
        }
        if (role.getColor() != rolejson.getInt("color")) {
            role.setColor(rolejson.getInt("color"));
            this.api.getEventManager().handle(new GuildRoleUpdateColorEvent(this.api, this.responseNumber, role));
        }
        if (role.isGrouped() != rolejson.getBoolean("hoist")) {
            role.setGrouped(rolejson.getBoolean("hoist"));
            this.api.getEventManager().handle(new GuildRoleUpdateGroupedEvent(this.api, this.responseNumber, role));
        }
        if (role.isMentionable() != rolejson.getBoolean("mentionable")) {
            role.setMentionable(rolejson.getBoolean("mentionable"));
        }
        this.api.getEventManager().handle(new GuildRoleUpdateEvent(this.api, this.responseNumber, role));
        return null;
    }
}

