/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.guild.member.GuildMemberNickChangeEvent;
import net.dv8tion.jda.events.guild.member.GuildMemberRoleAddEvent;
import net.dv8tion.jda.events.guild.member.GuildMemberRoleRemoveEvent;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONArray;
import org.json.JSONObject;

public class GuildMemberUpdateHandler
extends SocketHandler {
    public GuildMemberUpdateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        JSONObject userJson = content.getJSONObject("user");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
        User user = this.api.getUserMap().get(userJson.getString("id"));
        List<Role> rolesNew = this.toRolesList(guild, content.getJSONArray("roles"));
        List<Role> rolesOld = guild.getUserRoles().get(user);
        if (rolesOld == null) {
            EventCache.get(this.api).cache(EventCache.Type.USER, userJson.getString("id"), () -> this.handle(this.allContent));
            EventCache.LOG.debug("Got role-update for user which is not in guild? " + content.toString());
            return null;
        }
        LinkedList<Role> removedRoles = new LinkedList<Role>();
        for (Role role : rolesOld) {
            boolean roleFound = false;
            Iterator<Role> added = rolesNew.iterator();
            while (added.hasNext()) {
                Role r = added.next();
                if (!role.equals(r)) continue;
                added.remove();
                roleFound = true;
                break;
            }
            if (roleFound) continue;
            removedRoles.add(role);
        }
        if (removedRoles.size() > 0) {
            rolesOld.removeAll(removedRoles);
        }
        if (rolesNew.size() > 0) {
            rolesOld.addAll(rolesNew);
        }
        Collections.sort(rolesOld, (r1, r2) -> r2.compareTo(r1));
        if (removedRoles.size() > 0) {
            this.api.getEventManager().handle(new GuildMemberRoleRemoveEvent(this.api, this.responseNumber, guild, user, removedRoles));
        }
        if (rolesNew.size() > 0) {
            this.api.getEventManager().handle(new GuildMemberRoleAddEvent(this.api, this.responseNumber, guild, user, rolesNew));
        }
        if (content.has("nick")) {
            Map<User, String> nickMap = guild.getNickMap();
            String prevNick = nickMap.get(user);
            if (content.isNull("nick")) {
                if (prevNick != null) {
                    nickMap.remove(user);
                    this.api.getEventManager().handle(new GuildMemberNickChangeEvent(this.api, this.responseNumber, guild, user, prevNick, null));
                }
            } else if (!content.getString("nick").equals(prevNick)) {
                nickMap.put(user, content.getString("nick"));
                this.api.getEventManager().handle(new GuildMemberNickChangeEvent(this.api, this.responseNumber, guild, user, prevNick, content.getString("nick")));
            }
        }
        return null;
    }

    private List<Role> toRolesList(GuildImpl guild, JSONArray array) {
        LinkedList<Role> roles = new LinkedList<Role>();
        for (int i = 0; i < array.length(); ++i) {
            Role r = guild.getRolesMap().get(array.getString(i));
            if (r == null) continue;
            roles.add(r);
        }
        return roles;
    }
}

