/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.entities.impl.VoiceStatusImpl;
import net.dv8tion.jda.events.guild.member.GuildMemberLeaveEvent;
import net.dv8tion.jda.events.voice.VoiceLeaveEvent;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class GuildMemberRemoveHandler
extends SocketHandler {
    public GuildMemberRemoveHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
        if (guild == null) {
            return null;
        }
        UserImpl user = (UserImpl)this.api.getUserMap().get(content.getJSONObject("user").getString("id"));
        if (guild.getVoiceStatusMap().get(user).inVoiceChannel()) {
            VoiceStatusImpl status = (VoiceStatusImpl)guild.getVoiceStatusMap().get(user);
            VoiceChannel channel = status.getChannel();
            status.setChannel(null);
            ((VoiceChannelImpl)channel).getUsersModifiable().remove(user);
            this.api.getEventManager().handle(new VoiceLeaveEvent(this.api, this.responseNumber, status, channel));
        }
        guild.getVoiceStatusMap().remove(user);
        guild.getUserRoles().remove(user);
        guild.getJoinedAtMap().remove(user);
        if (!this.api.getGuildMap().values().stream().anyMatch(g -> ((GuildImpl)g).getUserRoles().containsKey(user))) {
            if (user.hasPrivateChannel()) {
                this.api.getOffline_pms().put(user.getId(), user.getPrivateChannel().getId());
            }
            this.api.getUserMap().remove(user.getId());
        }
        this.api.getEventManager().handle(new GuildMemberLeaveEvent(this.api, this.responseNumber, guild, user));
        return null;
    }
}

