/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.time.OffsetDateTime;
import java.util.LinkedList;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.entities.impl.VoiceStatusImpl;
import net.dv8tion.jda.events.guild.member.GuildMemberJoinEvent;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class GuildMemberAddHandler
extends SocketHandler {
    public GuildMemberAddHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
        User user = new EntityBuilder(this.api).createUser(content.getJSONObject("user"));
        if (this.api.getOffline_pms().containsKey(user.getId())) {
            PrivateChannelImpl pc = new PrivateChannelImpl(this.api.getOffline_pms().get(user.getId()), user, this.api);
            ((UserImpl)user).setPrivateChannel(pc);
            this.api.getOffline_pms().remove(user.getId());
        }
        guild.getUserRoles().put(user, new LinkedList());
        VoiceStatusImpl voiceStatus = new VoiceStatusImpl(user, guild);
        guild.getVoiceStatusMap().put(user, voiceStatus);
        guild.getJoinedAtMap().put(user, OffsetDateTime.parse(content.getString("joined_at")));
        this.api.getEventManager().handle(new GuildMemberJoinEvent(this.api, this.responseNumber, guild, user));
        EventCache.get(this.api).playbackCache(EventCache.Type.USER, user.getId());
        return null;
    }
}

