/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.EmbedType;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.OnlineStatus;
import net.dv8tion.jda.Region;
import net.dv8tion.jda.entities.Channel;
import net.dv8tion.jda.entities.ChannelType;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Game;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.MessageEmbed;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.SelfInfo;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.VoiceStatus;
import net.dv8tion.jda.entities.impl.EmoteImpl;
import net.dv8tion.jda.entities.impl.GameImpl;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.MessageEmbedImpl;
import net.dv8tion.jda.entities.impl.MessageImpl;
import net.dv8tion.jda.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.entities.impl.RoleImpl;
import net.dv8tion.jda.entities.impl.SelfInfoImpl;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.entities.impl.VoiceStatusImpl;
import net.dv8tion.jda.handle.GuildMembersChunkHandler;
import net.dv8tion.jda.handle.ReadyHandler;
import net.dv8tion.jda.requests.GuildLock;
import net.dv8tion.jda.requests.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntityBuilder {
    private static final HashMap<JDA, HashMap<String, JSONObject>> cachedJdaGuildJsons = new HashMap();
    private static final HashMap<JDA, HashMap<String, Consumer<Guild>>> cachedJdaGuildCallbacks = new HashMap();
    private static final Pattern channelMentionPattern = Pattern.compile("<#(\\d+)>");
    private static final Pattern emotePatter = Pattern.compile("<:([^:]+):(\\d+)>");
    private final JDAImpl api;

    public EntityBuilder(JDAImpl api) {
        this.api = api;
        if (!cachedJdaGuildCallbacks.containsKey(api)) {
            cachedJdaGuildCallbacks.put(api, new HashMap());
        }
        if (!cachedJdaGuildJsons.containsKey(api)) {
            cachedJdaGuildJsons.put(api, new HashMap());
        }
    }

    public void clearCache() {
        cachedJdaGuildCallbacks.get(this.api).clear();
        cachedJdaGuildJsons.get(this.api).clear();
    }

    public Guild createGuildFirstPass(JSONObject guild, Consumer<Guild> secondPassCallback) {
        User user;
        User owner;
        String id = guild.getString("id");
        GuildImpl guildObj = (GuildImpl)this.api.getGuildMap().get(id);
        if (guildObj == null) {
            guildObj = new GuildImpl(this.api, id);
            this.api.getGuildMap().put(id, guildObj);
        }
        if (guild.has("unavailable") && guild.getBoolean("unavailable")) {
            guildObj.setAvailable(false);
            if (secondPassCallback != null) {
                secondPassCallback.accept(guildObj);
            }
            GuildLock.get(this.api).lock(id);
            return guildObj;
        }
        guildObj.setAvailable(true).setIconId(guild.isNull("icon") ? null : guild.getString("icon")).setRegion(Region.fromKey(guild.getString("region"))).setName(guild.getString("name")).setAfkTimeout(guild.getInt("afk_timeout")).setAfkChannelId(guild.isNull("afk_channel_id") ? null : guild.getString("afk_channel_id")).setVerificationLevel(Guild.VerificationLevel.fromKey(guild.getInt("verification_level")));
        JSONArray roles = guild.getJSONArray("roles");
        for (int i = 0; i < roles.length(); ++i) {
            Role role = this.createRole(roles.getJSONObject(i), guildObj.getId());
            guildObj.getRolesMap().put(role.getId(), role);
            if (!role.getId().equals(guildObj.getId())) continue;
            guildObj.setPublicRole(role);
        }
        if (guild.has("emojis")) {
            JSONArray emojiArr = guild.getJSONArray("emojis");
            for (int i = 0; i < emojiArr.length(); ++i) {
                JSONObject obj = emojiArr.getJSONObject(i);
                String emojID = obj.getString("id");
                Emote emote = this.api.getEmoteById(emojID);
                if (emote == null) {
                    emote = new EmoteImpl(obj.getString("name"), emojID);
                }
                this.api.getEmoteMap().putIfAbsent(emojID, emote);
                guildObj.getEmoteMap().put(emojID, emote);
                ((EmoteImpl)emote).addGuild(guildObj);
            }
        } else {
            JDAImpl.LOG.warn("Guild Didn't have field called 'emojis'. Identifier: " + guildObj.getId());
        }
        if (guild.has("members")) {
            JSONArray members = guild.getJSONArray("members");
            this.createGuildMemberPass(guildObj, members);
        }
        if ((owner = this.api.getUserById(guild.getString("owner_id"))) != null) {
            guildObj.setOwner(owner);
        }
        if (guild.has("presences")) {
            JSONArray presences = guild.getJSONArray("presences");
            for (int i = 0; i < presences.length(); ++i) {
                JSONObject presence = presences.getJSONObject(i);
                user = (UserImpl)this.api.getUserMap().get(presence.getJSONObject("user").getString("id"));
                if (user == null) continue;
                GameImpl presenceGame = null;
                if (!presence.isNull("game") && !presence.getJSONObject("game").isNull("name")) {
                    presenceGame = new GameImpl(presence.getJSONObject("game").get("name").toString(), presence.getJSONObject("game").isNull("url") ? null : presence.getJSONObject("game").get("url").toString(), presence.getJSONObject("game").isNull("type") ? Game.GameType.DEFAULT : Game.GameType.fromKey((Integer)presence.getJSONObject("game").get("type")));
                }
                ((UserImpl)user).setCurrentGame(presenceGame).setOnlineStatus(OnlineStatus.fromKey(presence.getString("status")));
            }
        }
        if (guild.has("channels")) {
            JSONArray channels = guild.getJSONArray("channels");
            for (int i = 0; i < channels.length(); ++i) {
                JSONObject channel = channels.getJSONObject(i);
                ChannelType type = ChannelType.fromId(channel.getInt("type"));
                if (type == ChannelType.TEXT) {
                    TextChannel newChannel = this.createTextChannel(channel, guildObj.getId());
                    if (!newChannel.getId().equals(guildObj.getId())) continue;
                    guildObj.setPublicChannel(newChannel);
                    continue;
                }
                if (type == ChannelType.VOICE) {
                    this.createVoiceChannel(channel, guildObj.getId());
                    continue;
                }
                JDAImpl.LOG.fatal("Received a channel for a guild that isn't a text or voice channel. JSON: " + channel);
            }
        }
        if (guild.has("voice_states")) {
            JSONArray voiceStates = guild.getJSONArray("voice_states");
            for (int i = 0; i < voiceStates.length(); ++i) {
                JSONObject voiceState = voiceStates.getJSONObject(i);
                user = this.api.getUserById(voiceState.getString("user_id"));
                if (user == null) continue;
                try {
                    VoiceStatus voiceStatus = this.createVoiceStatus(voiceState, guildObj, user);
                    ((VoiceChannelImpl)voiceStatus.getChannel()).getUsersModifiable().add(user);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (secondPassCallback != null && guild.has("large") && guild.getBoolean("large")) {
            HashMap<String, JSONObject> cachedGuildJsons = cachedJdaGuildJsons.get(this.api);
            HashMap<String, Consumer<Guild>> cachedGuildCallbacks = cachedJdaGuildCallbacks.get(this.api);
            cachedGuildJsons.put(id, guild);
            cachedGuildCallbacks.put(id, secondPassCallback);
            GuildMembersChunkHandler.setExpectedGuildMembers(this.api, id, guild.getInt("member_count"));
            if (this.api.getClient().isReady()) {
                JSONObject obj = new JSONObject().put("op", 8).put("d", new JSONObject().put("guild_id", id).put("query", "").put("limit", 0));
                this.api.getClient().send(obj.toString());
            } else {
                new ReadyHandler(this.api, 0).onGuildNeedsMembers(guildObj);
            }
            GuildLock.get(this.api).lock(id);
            return null;
        }
        JSONArray channels = guild.getJSONArray("channels");
        this.createGuildChannelPass(guildObj, channels);
        if (secondPassCallback != null) {
            secondPassCallback.accept(guildObj);
            GuildLock.get(this.api).unlock(guildObj.getId());
            return null;
        }
        GuildLock.get(this.api).unlock(guildObj.getId());
        return guildObj;
    }

    public void createGuildSecondPass(String guildId, List<JSONArray> memberChunks) {
        HashMap<String, JSONObject> cachedGuildJsons = cachedJdaGuildJsons.get(this.api);
        HashMap<String, Consumer<Guild>> cachedGuildCallbacks = cachedJdaGuildCallbacks.get(this.api);
        JSONObject guildJson = cachedGuildJsons.remove(guildId);
        Consumer<Guild> secondPassCallback = cachedGuildCallbacks.remove(guildId);
        GuildImpl guildObj = (GuildImpl)this.api.getGuildMap().get(guildId);
        if (guildObj == null) {
            throw new IllegalStateException("Attempted to preform a second pass on an unknown Guild. Guild not in JDA mapping. GuildId: " + guildId);
        }
        if (guildJson == null) {
            throw new IllegalStateException("Attempted to preform a second pass on an unknown Guild. No cached Guild for second pass. GuildId: " + guildId);
        }
        if (secondPassCallback == null) {
            throw new IllegalArgumentException("No callback provided for the second pass on the Guild!");
        }
        for (JSONArray chunk : memberChunks) {
            this.createGuildMemberPass(guildObj, chunk);
        }
        User owner = this.api.getUserById(guildJson.getString("owner_id"));
        if (owner != null) {
            guildObj.setOwner(owner);
        }
        if (guildObj.getOwner() == null) {
            JDAImpl.LOG.fatal("Never set the Owner of the Guild: " + guildObj.getId() + " because we don't have the owner User object! How?!");
        }
        JSONArray channels = guildJson.getJSONArray("channels");
        this.createGuildChannelPass(guildObj, channels);
        secondPassCallback.accept(guildObj);
        GuildLock.get(this.api).unlock(guildId);
    }

    private void createGuildMemberPass(GuildImpl guildObj, JSONArray members) {
        Map<String, Role> rolesMap = guildObj.getRolesMap();
        Map<User, List<Role>> userRoles = guildObj.getUserRoles();
        Map<User, VoiceStatus> voiceStatusMap = guildObj.getVoiceStatusMap();
        Map<User, OffsetDateTime> joinedAtMap = guildObj.getJoinedAtMap();
        Map<User, String> nickMap = guildObj.getNickMap();
        for (int i = 0; i < members.length(); ++i) {
            JSONObject member = members.getJSONObject(i);
            User user = this.createUser(member.getJSONObject("user"));
            userRoles.put(user, new ArrayList());
            JSONArray roleArr = member.getJSONArray("roles");
            for (int j = 0; j < roleArr.length(); ++j) {
                String roleId = roleArr.getString(j);
                Role role = rolesMap.get(roleId);
                if (role != null) {
                    userRoles.get(user).add(role);
                    continue;
                }
                WebSocketClient.LOG.warn("While building the guild users, encountered a user that is assigned a non-existent role. This is a Discord error, not a JDA error. Ignoring the role. GuildId: " + guildObj.getId() + " UserId: " + user.getId() + " RoleId: " + roleId);
            }
            VoiceStatusImpl voiceStatus = new VoiceStatusImpl(user, guildObj);
            voiceStatus.setServerDeaf(member.getBoolean("deaf"));
            voiceStatus.setServerMute(member.getBoolean("mute"));
            voiceStatusMap.put(user, voiceStatus);
            joinedAtMap.put(user, OffsetDateTime.parse(member.getString("joined_at")));
            if (!member.has("nick") || member.isNull("nick")) continue;
            nickMap.put(user, member.getString("nick"));
        }
    }

    private void createGuildChannelPass(GuildImpl guildObj, JSONArray channels) {
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject channel = channels.getJSONObject(i);
            ChannelType type = ChannelType.fromId(channel.getInt("type"));
            Channel channelObj = null;
            if (type == ChannelType.TEXT) {
                channelObj = this.api.getTextChannelById(channel.getString("id"));
            } else if (type == ChannelType.VOICE) {
                channelObj = this.api.getVoiceChannelById(channel.getString("id"));
            } else {
                JDAImpl.LOG.fatal("Received a channel for a guild that isn't a text or voice channel (ChannelPass). JSON: " + channel);
            }
            if (channelObj != null) {
                JSONArray permissionOverwrites = channel.getJSONArray("permission_overwrites");
                for (int j = 0; j < permissionOverwrites.length(); ++j) {
                    try {
                        this.createPermissionOverride(permissionOverwrites.getJSONObject(j), channelObj);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        WebSocketClient.LOG.warn(e.getMessage() + ". Ignoring PermissionOverride.");
                    }
                }
                continue;
            }
            throw new RuntimeException("Got permission_override for unknown channel with id: " + channel.getString("id"));
        }
    }

    public TextChannel createTextChannel(JSONObject json, String guildId) {
        String id = json.getString("id");
        TextChannelImpl channel = (TextChannelImpl)this.api.getChannelMap().get(id);
        if (channel == null) {
            GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
            channel = new TextChannelImpl(id, guild);
            guild.getTextChannelsMap().put(id, channel);
            this.api.getChannelMap().put(id, channel);
        }
        return channel.setName(json.getString("name")).setTopic(json.isNull("topic") ? "" : json.getString("topic")).setPosition(json.getInt("position"));
    }

    public VoiceChannel createVoiceChannel(JSONObject json, String guildId) {
        String id = json.getString("id");
        VoiceChannelImpl channel = (VoiceChannelImpl)this.api.getVoiceChannelMap().get(id);
        if (channel == null) {
            GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
            channel = new VoiceChannelImpl(id, guild);
            guild.getVoiceChannelsMap().put(id, channel);
            this.api.getVoiceChannelMap().put(id, channel);
        }
        return channel.setName(json.getString("name")).setPosition(json.getInt("position")).setUserLimit(json.getInt("user_limit")).setBitrate(json.getInt("bitrate"));
    }

    public PrivateChannel createPrivateChannel(JSONObject privatechat) {
        JSONObject recipient = privatechat.has("recipients") ? privatechat.getJSONArray("recipients").getJSONObject(0) : privatechat.getJSONObject("recipient");
        UserImpl user = (UserImpl)this.api.getUserMap().get(recipient.getString("id"));
        if (user == null) {
            this.api.getOffline_pms().put(recipient.getString("id"), privatechat.getString("id"));
            return null;
        }
        PrivateChannelImpl priv = new PrivateChannelImpl(privatechat.getString("id"), user, this.api);
        user.setPrivateChannel(priv);
        return priv;
    }

    public Role createRole(JSONObject roleJson, String guildId) {
        String id = roleJson.getString("id");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
        RoleImpl role = (RoleImpl)guild.getRolesMap().get(id);
        if (role == null) {
            role = new RoleImpl(id, guild);
            guild.getRolesMap().put(id, role);
        }
        role.setName(roleJson.getString("name")).setPosition(roleJson.getInt("position")).setPermissions(roleJson.getInt("permissions")).setManaged(roleJson.getBoolean("managed")).setGrouped(roleJson.getBoolean("hoist")).setMentionable(roleJson.has("mentionable") && roleJson.getBoolean("mentionable"));
        try {
            role.setColor(roleJson.getInt("color"));
        }
        catch (JSONException ex) {
            role.setColor(0);
        }
        return role;
    }

    protected User createUser(JSONObject user) {
        String id = user.getString("id");
        UserImpl userObj = (UserImpl)this.api.getUserMap().get(id);
        if (userObj == null) {
            userObj = new UserImpl(id, this.api);
            this.api.getUserMap().put(id, userObj);
        }
        return userObj.setUserName(user.getString("username")).setDiscriminator(user.get("discriminator").toString()).setAvatarId(user.isNull("avatar") ? null : user.getString("avatar")).setIsBot(user.has("bot") && user.getBoolean("bot"));
    }

    protected SelfInfo createSelfInfo(JSONObject self) {
        SelfInfoImpl selfInfo = (SelfInfoImpl)this.api.getSelfInfo();
        if (selfInfo == null) {
            selfInfo = new SelfInfoImpl(self.getString("id"), this.api);
            this.api.setSelfInfo(selfInfo);
        }
        if (!this.api.getUserMap().containsKey(selfInfo.getId())) {
            this.api.getUserMap().put(selfInfo.getId(), selfInfo);
        }
        return (SelfInfo)((Object)selfInfo.setVerified(self.getBoolean("verified")).setUserName(self.getString("username")).setDiscriminator(self.getString("discriminator")).setAvatarId(self.isNull("avatar") ? null : self.getString("avatar")).setIsBot(self.has("bot") && self.getBoolean("bot")));
    }

    public Message createMessage(JSONObject jsonObject) {
        String id = jsonObject.getString("id");
        String content = jsonObject.getString("content");
        MessageImpl message = new MessageImpl(id, this.api).setAuthor(this.api.getUserMap().get(jsonObject.getJSONObject("author").getString("id"))).setContent(content).setTime(OffsetDateTime.parse(jsonObject.getString("timestamp"))).setMentionsEveryone(jsonObject.getBoolean("mention_everyone")).setTTS(jsonObject.getBoolean("tts")).setPinned(jsonObject.getBoolean("pinned"));
        LinkedList<Message.Attachment> attachments = new LinkedList<Message.Attachment>();
        JSONArray jsonAttachments = jsonObject.getJSONArray("attachments");
        for (int i = 0; i < jsonAttachments.length(); ++i) {
            JSONObject jsonAttachment = jsonAttachments.getJSONObject(i);
            attachments.add(new Message.Attachment(jsonAttachment.getString("id"), jsonAttachment.getString("url"), jsonAttachment.getString("proxy_url"), jsonAttachment.getString("filename"), jsonAttachment.getInt("size"), jsonAttachment.has("height") ? jsonAttachment.getInt("height") : 0, jsonAttachment.has("width") ? jsonAttachment.getInt("width") : 0, this.api));
        }
        message.setAttachments(attachments);
        LinkedList<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
        JSONArray jsonEmbeds = jsonObject.getJSONArray("embeds");
        for (int i = 0; i < jsonEmbeds.length(); ++i) {
            embeds.add(this.createMessageEmbed(jsonEmbeds.getJSONObject(i)));
        }
        message.setEmbeds(embeds);
        Matcher matcher = emotePatter.matcher(content);
        LinkedList<Emote> emoteList = new LinkedList<Emote>();
        while (matcher.find()) {
            emoteList.add(this.api.getEmoteById(matcher.group(2)) == null ? new EmoteImpl(matcher.group(1), matcher.group(2)) : this.api.getEmoteById(matcher.group(2)));
        }
        message.setEmotes(emoteList);
        if (!jsonObject.isNull("edited_timestamp")) {
            message.setEditedTime(OffsetDateTime.parse(jsonObject.getString("edited_timestamp")));
        }
        String channelId = jsonObject.getString("channel_id");
        TextChannel textChannel = this.api.getChannelMap().get(channelId);
        if (textChannel != null) {
            message.setChannelId(textChannel.getId());
            message.setIsPrivate(false);
            TreeMap<Integer, User> mentionedUsers = new TreeMap<Integer, User>();
            JSONArray mentions = jsonObject.getJSONArray("mentions");
            for (int i = 0; i < mentions.length(); ++i) {
                JSONObject mention = mentions.getJSONObject(i);
                User u = this.api.getUserMap().get(mention.getString("id"));
                if (u == null) continue;
                int index = content.indexOf("<@" + mention.getString("id") + ">");
                mentionedUsers.put(index, u);
            }
            message.setMentionedUsers(new LinkedList<User>(mentionedUsers.values()));
            TreeMap<Integer, Role> mentionedRoles = new TreeMap<Integer, Role>();
            JSONArray roleMentions = jsonObject.getJSONArray("mention_roles");
            for (int i = 0; i < roleMentions.length(); ++i) {
                String roleId = roleMentions.getString(i);
                Role r = textChannel.getGuild().getRoleById(roleId);
                if (r == null) continue;
                int index = content.indexOf("<@&" + roleId + ">");
                mentionedRoles.put(index, r);
            }
            message.setMentionedRoles(new LinkedList<Role>(mentionedRoles.values()));
            LinkedList<TextChannel> mentionedChannels = new LinkedList<TextChannel>();
            Map<String, TextChannel> chanMap = ((GuildImpl)textChannel.getGuild()).getTextChannelsMap();
            matcher = channelMentionPattern.matcher(content);
            while (matcher.find()) {
                TextChannel channel = chanMap.get(matcher.group(1));
                if (channel == null || mentionedChannels.contains(channel)) continue;
                mentionedChannels.add(channel);
            }
            message.setMentionedChannels(mentionedChannels);
        } else {
            message.setIsPrivate(true);
            PrivateChannel privateChannel = this.api.getPmChannelMap().get(channelId);
            if (privateChannel != null) {
                message.setChannelId(privateChannel.getId());
            } else {
                throw new IllegalArgumentException("Could not find Private/Text Channel of id " + channelId);
            }
        }
        return message;
    }

    protected MessageEmbed createMessageEmbed(JSONObject messageEmbed) {
        MessageEmbedImpl embed = new MessageEmbedImpl().setUrl(messageEmbed.getString("url")).setTitle(messageEmbed.isNull("title") ? null : messageEmbed.getString("title")).setDescription(messageEmbed.isNull("description") ? null : messageEmbed.getString("description"));
        EmbedType type = EmbedType.fromKey(messageEmbed.getString("type"));
        embed.setType(type);
        if (messageEmbed.has("thumbnail")) {
            JSONObject thumbnailJson = messageEmbed.getJSONObject("thumbnail");
            embed.setThumbnail(new MessageEmbed.Thumbnail(thumbnailJson.getString("url"), thumbnailJson.getString("proxy_url"), thumbnailJson.getInt("width"), thumbnailJson.getInt("height")));
        } else {
            embed.setThumbnail(null);
        }
        if (messageEmbed.has("provider")) {
            JSONObject providerJson = messageEmbed.getJSONObject("provider");
            embed.setSiteProvider(new MessageEmbed.Provider(providerJson.isNull("name") ? null : providerJson.getString("name"), providerJson.isNull("url") ? null : providerJson.getString("url")));
        } else {
            embed.setSiteProvider(null);
        }
        if (messageEmbed.has("author")) {
            JSONObject authorJson = messageEmbed.getJSONObject("author");
            embed.setAuthor(new MessageEmbed.Provider(authorJson.isNull("name") ? null : authorJson.getString("name"), authorJson.isNull("url") ? null : authorJson.getString("url")));
        } else {
            embed.setAuthor(null);
        }
        if (messageEmbed.has("video")) {
            JSONObject videoJson = messageEmbed.getJSONObject("video");
            embed.setVideoInfo(new MessageEmbed.VideoInfo(videoJson.getString("url"), videoJson.isNull("width") ? -1 : videoJson.getInt("width"), videoJson.isNull("height") ? -1 : videoJson.getInt("height")));
        }
        return embed;
    }

    public PermissionOverride createPermissionOverride(JSONObject override, Channel chan) {
        PermissionOverrideImpl permOverride = null;
        String id = override.getString("id");
        int allow = override.getInt("allow");
        int deny = override.getInt("deny");
        switch (override.getString("type")) {
            case "member": {
                User user = this.api.getUserById(id);
                if (user == null) {
                    throw new IllegalArgumentException("Attempted to create a PermissionOverride for a non-existent user. Guild: " + chan.getGuild() + ", Channel: " + chan + ", JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getOverrideForUser(user);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, user, null);
                if (chan instanceof TextChannel) {
                    ((TextChannelImpl)chan).getUserPermissionOverridesMap().put(user, permOverride);
                    break;
                }
                ((VoiceChannelImpl)chan).getUserPermissionOverridesMap().put(user, permOverride);
                break;
            }
            case "role": {
                Role role = ((GuildImpl)chan.getGuild()).getRolesMap().get(id);
                if (role == null) {
                    throw new IllegalArgumentException("Attempted to create a PermissionOverride for a non-existent role! JSON: " + override);
                }
                permOverride = (PermissionOverrideImpl)chan.getOverrideForRole(role);
                if (permOverride != null) break;
                permOverride = new PermissionOverrideImpl(chan, null, role);
                if (chan instanceof TextChannel) {
                    ((TextChannelImpl)chan).getRolePermissionOverridesMap().put(role, permOverride);
                    break;
                }
                ((VoiceChannelImpl)chan).getRolePermissionOverridesMap().put(role, permOverride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided with an unknown PermissionOverride type! JSON: " + override);
            }
        }
        return permOverride.setAllow(allow).setDeny(deny);
    }

    public VoiceStatus createVoiceStatus(JSONObject status, Guild guildObj, User user) {
        GuildImpl guild = (GuildImpl)guildObj;
        VoiceStatusImpl voiceStatus = (VoiceStatusImpl)guild.getVoiceStatusMap().get(user);
        if (voiceStatus == null) {
            voiceStatus = new VoiceStatusImpl(user, guild);
            guild.getVoiceStatusMap().put(user, voiceStatus);
        }
        if (!status.isNull("channel_id")) {
            VoiceChannel channel = guild.getVoiceChannelsMap().get(status.getString("channel_id"));
            if (channel == null) {
                throw new IllegalArgumentException("Attempted to create a VoiceStatus using a non-existant channel! JSON: " + status);
            }
            voiceStatus.setChannel(channel);
        } else {
            voiceStatus.setChannel(null);
        }
        if (!status.isNull("session_id")) {
            voiceStatus.setSessionId(status.getString("session_id"));
        } else {
            voiceStatus.setSessionId(null);
        }
        return voiceStatus.setMute(status.getBoolean("self_mute")).setDeaf(status.getBoolean("self_deaf")).setServerMute(status.getBoolean("mute")).setServerDeaf(status.getBoolean("deaf")).setSuppressed(status.getBoolean("suppress"));
    }
}

