/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.VoiceStatus;

public class VoiceStatusImpl
implements VoiceStatus {
    private final User user;
    private final Guild guild;
    private VoiceChannel channel = null;
    private boolean mute = false;
    private boolean serverMute = false;
    private boolean deaf = false;
    private boolean serverDeaf = false;
    private boolean suppressed = false;
    private String sessionId = null;

    public VoiceStatusImpl(User user, Guild guild) {
        this.user = user;
        this.guild = guild;
    }

    @Override
    public boolean isMuted() {
        return this.mute;
    }

    @Override
    public boolean isServerMuted() {
        return this.serverMute;
    }

    @Override
    public boolean isDeaf() {
        return this.deaf;
    }

    @Override
    public boolean isServerDeaf() {
        return this.serverDeaf;
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressed;
    }

    @Override
    public VoiceChannel getChannel() {
        return this.channel;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean inVoiceChannel() {
        return this.getChannel() != null;
    }

    public VoiceStatusImpl setMute(boolean mute) {
        this.mute = mute;
        return this;
    }

    public VoiceStatusImpl setServerMute(boolean serverMute) {
        this.serverMute = serverMute;
        return this;
    }

    public VoiceStatusImpl setDeaf(boolean deaf) {
        this.deaf = deaf;
        return this;
    }

    public VoiceStatusImpl setServerDeaf(boolean serverDeaf) {
        this.serverDeaf = serverDeaf;
        return this;
    }

    public VoiceStatusImpl setChannel(VoiceChannel channel) {
        this.channel = channel;
        return this;
    }

    public VoiceStatusImpl setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public VoiceStatusImpl setSuppressed(boolean suppressed) {
        this.suppressed = suppressed;
        return this;
    }

    public int hashCode() {
        return this.guild.getId().hashCode() | this.user.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VoiceStatus)) {
            return false;
        }
        VoiceStatus oStatus = (VoiceStatus)obj;
        return this == oStatus || this.user.equals(oStatus.getUser()) && this.guild.equals(oStatus.getGuild());
    }

    public String toString() {
        return "VS:" + this.guild.getName() + ':' + this.user.getUsername();
    }
}

