/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.MessageBuilder;
import net.dv8tion.jda.MessageHistory;
import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.MessageImpl;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.exceptions.BlockedException;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.exceptions.RateLimitedException;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.requests.Requester;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PrivateChannelImpl
implements PrivateChannel {
    public static final String RATE_LIMIT_IDENTIFIER = "GLOBAL_PRIV_CHANNEL_RATELIMIT";
    private final String id;
    private final User user;
    private final JDAImpl api;

    public PrivateChannelImpl(String id, User user, JDAImpl api) {
        this.id = id;
        this.user = user;
        this.api = api;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Message sendMessage(String text) {
        return this.sendMessage(new MessageBuilder().appendString(text).build());
    }

    @Override
    public Message sendMessage(Message msg) {
        if (this.api.getMessageLimit(RATE_LIMIT_IDENTIFIER) != null) {
            throw new RateLimitedException(this.api.getMessageLimit(RATE_LIMIT_IDENTIFIER) - System.currentTimeMillis());
        }
        try {
            Requester.Response response = this.api.getRequester().post("https://discordapp.com/api/channels/" + this.getId() + "/messages", new JSONObject().put("content", msg.getRawContent()));
            if (response.isRateLimit()) {
                long retry_after = response.getObject().getLong("retry_after");
                this.api.setMessageTimeout(RATE_LIMIT_IDENTIFIER, retry_after);
                throw new RateLimitedException(retry_after);
            }
            if (!response.isOk()) {
                throw new BlockedException();
            }
            return new EntityBuilder(this.api).createMessage(response.getObject());
        }
        catch (JSONException ex) {
            JDAImpl.LOG.log(ex);
            return null;
        }
    }

    @Override
    public void sendMessageAsync(String text, Consumer<Message> callback) {
        this.sendMessageAsync(new MessageBuilder().appendString(text).build(), callback);
    }

    @Override
    public void sendMessageAsync(Message msg, Consumer<Message> callback) {
        ((MessageImpl)msg).setChannelId(this.id);
        TextChannelImpl.AsyncMessageSender.getInstance(this.getJDA(), RATE_LIMIT_IDENTIFIER).enqueue(msg, false, callback);
    }

    @Override
    public Message sendFile(File file, Message message) {
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Provided file is either null, doesn't exist or is not readable!");
        }
        if (file.length() > 0x800000L) {
            throw new IllegalArgumentException("File is to big! Max file-size is 8MB");
        }
        JDAImpl api = (JDAImpl)this.getJDA();
        try {
            MultipartBody body = Unirest.post("https://discordapp.com/api/channels/" + this.getId() + "/messages").header("authorization", this.getJDA().getAuthToken()).header("user-agent", Requester.USER_AGENT).field("file", file);
            if (message != null) {
                body.field("content", message.getRawContent()).field("tts", message.isTTS());
            }
            String dbg = String.format("Requesting %s -> %s\n\tPayload: file: %s, message: %s, tts: %s\n\tResponse: ", body.getHttpRequest().getHttpMethod().name(), body.getHttpRequest().getUrl(), file.getAbsolutePath(), message == null ? "null" : message.getRawContent(), message == null ? "N/A" : Boolean.valueOf(message.isTTS()));
            HttpResponse<JsonNode> response = body.asJson();
            Requester.LOG.trace(dbg + body);
            try {
                int status = response.getStatus();
                if (status >= 200 && status < 300) {
                    return new EntityBuilder(api).createMessage(response.getBody().getObject());
                }
                if (response.getStatus() == 429) {
                    long retryAfter = response.getBody().getObject().getLong("retry_after");
                    api.setMessageTimeout(RATE_LIMIT_IDENTIFIER, retryAfter);
                    throw new RateLimitedException(retryAfter);
                }
                throw new RuntimeException("An unknown status code was returned when attempting to upload file. Status: " + status + " JSON: " + response.getBody().toString());
            }
            catch (JSONException e) {
                Requester.LOG.fatal("Following json caused an exception: " + response.getBody().toString());
                Requester.LOG.log(e);
            }
        }
        catch (UnirestException e) {
            Requester.LOG.log(e);
        }
        return null;
    }

    @Override
    public void sendFileAsync(File file, Message message, Consumer<Message> callback) {
        Thread thread = new Thread(() -> {
            Message messageReturn;
            try {
                messageReturn = this.sendFile(file, message);
            }
            catch (RateLimitedException e) {
                JDAImpl.LOG.warn("Got ratelimited when trying to upload file. Providing null to callback.");
                messageReturn = null;
            }
            if (callback != null) {
                callback.accept(messageReturn);
            }
        });
        thread.setName("PrivateChannelImpl SendFileAsync Channel: " + this.id);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public Message getMessageById(String messageId) {
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().get("https://discordapp.com/api/channels/" + this.id + "/messages/" + messageId);
        if (response.isOk()) {
            return new EntityBuilder((JDAImpl)this.getJDA()).createMessage(response.getObject());
        }
        return null;
    }

    @Override
    public boolean deleteMessageById(String messageId) {
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().delete("https://discordapp.com/api/channels/" + this.id + "/messages/" + messageId);
        if (response.isOk()) {
            return true;
        }
        if (response.code == 403) {
            throw new PermissionException("Cannot delete another User's messages in a PrivateChannel.");
        }
        return false;
    }

    @Override
    public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @Override
    public void sendTyping() {
        this.api.getRequester().post("https://discordapp.com/api/channels/" + this.getId() + "/typing", new JSONObject());
    }

    @Override
    public boolean pinMessageById(String messageId) {
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().put("https://discordapp.com/api//channels/" + this.id + "/pins/" + messageId, new JSONObject());
        if (response.isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
        return response.isOk();
    }

    @Override
    public boolean unpinMessageById(String messageId) {
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().delete("https://discordapp.com/api//channels/" + this.id + "/pins/" + messageId);
        if (response.isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
        return response.isOk();
    }

    @Override
    public List<Message> getPinnedMessages() {
        LinkedList<Message> pinnedMessages = new LinkedList<Message>();
        Requester.Response response = ((JDAImpl)this.getJDA()).getRequester().get("https://discordapp.com/api//channels/" + this.id + "/pins");
        if (response.isOk()) {
            JSONArray pins = response.getArray();
            for (int i = 0; i < pins.length(); ++i) {
                pinnedMessages.add(new EntityBuilder((JDAImpl)this.getJDA()).createMessage(pins.getJSONObject(i)));
            }
            return Collections.unmodifiableList(pinnedMessages);
        }
        if (response.isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
        throw new RuntimeException("An unknown error occured attempting to get pinned messages. Ask devs for help.\n" + response);
    }

    @Override
    public void close() {
        this.api.getRequester().delete("https://discordapp.com/api/channels/" + this.getId());
    }

    public boolean equals(Object o) {
        if (!(o instanceof PrivateChannel)) {
            return false;
        }
        PrivateChannel oPChannel = (PrivateChannel)o;
        return this == oPChannel || this.getId().equals(oPChannel.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "PC:" + this.getUser().getUsername() + '(' + this.getId() + ')';
    }
}

