/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.MessageChannel;
import net.dv8tion.jda.entities.MessageEmbed;
import net.dv8tion.jda.entities.MessageType;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.exceptions.RateLimitedException;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.requests.Requester;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageImpl
implements Message {
    private final JDAImpl api;
    private final String id;
    private final MessageType type;
    private boolean mentionsEveryone = false;
    private boolean isTTS = false;
    private boolean isPrivate;
    private boolean pinned;
    private String channelId;
    private String content;
    private String subContent = null;
    private String strippedContent = null;
    private User author;
    private OffsetDateTime time;
    private OffsetDateTime editedTime = null;
    private List<User> mentionedUsers = new LinkedList<User>();
    private List<TextChannel> mentionedChannels = new LinkedList<TextChannel>();
    private List<Role> mentionedRoles = new LinkedList<Role>();
    private List<Message.Attachment> attachments = new LinkedList<Message.Attachment>();
    private List<MessageEmbed> embeds = new LinkedList<MessageEmbed>();
    private List<Emote> emotes = new LinkedList<Emote>();

    public MessageImpl(String id, JDAImpl api) {
        this(id, api, MessageType.DEFAULT);
    }

    public MessageImpl(String id, JDAImpl api, MessageType type) {
        this.id = id;
        this.api = api;
        this.type = type;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    public MessageImpl setPinned(boolean pinned) {
        this.pinned = pinned;
        return this;
    }

    @Override
    public boolean pin() {
        boolean result = this.getChannel().pinMessageById(this.id);
        if (result) {
            this.pinned = true;
        }
        return result;
    }

    @Override
    public boolean unpin() {
        boolean result = this.getChannel().unpinMessageById(this.id);
        if (result) {
            this.pinned = false;
        }
        return result;
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<User> getMentionedUsers() {
        return Collections.unmodifiableList(this.mentionedUsers);
    }

    @Override
    public boolean isMentioned(User user) {
        return this.mentionsEveryone() || this.mentionedUsers.contains(user);
    }

    @Override
    public List<TextChannel> getMentionedChannels() {
        return Collections.unmodifiableList(this.mentionedChannels);
    }

    @Override
    public List<Role> getMentionedRoles() {
        return Collections.unmodifiableList(this.mentionedRoles);
    }

    @Override
    public boolean mentionsEveryone() {
        return this.mentionsEveryone;
    }

    @Override
    public OffsetDateTime getTime() {
        return this.time;
    }

    @Override
    public boolean isEdited() {
        return this.editedTime != null;
    }

    @Override
    public OffsetDateTime getEditedTimestamp() {
        return this.editedTime;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public String getContent() {
        if (this.subContent == null) {
            Guild g = this.isPrivate ? null : this.api.getTextChannelById(this.channelId).getGuild();
            String tmp = this.content;
            for (User user : this.mentionedUsers) {
                if (this.isPrivate) {
                    tmp = tmp.replace("<@" + user.getId() + '>', '@' + user.getUsername()).replace("<@!" + user.getId() + '>', '@' + user.getUsername());
                    continue;
                }
                String name = g.getNicknameForUser(user);
                if (name == null) {
                    name = user.getUsername();
                }
                tmp = tmp.replace("<@" + user.getId() + '>', '@' + name).replace("<@!" + user.getId() + '>', '@' + name);
            }
            for (TextChannel mentionedChannel : this.mentionedChannels) {
                tmp = tmp.replace("<#" + mentionedChannel.getId() + '>', '#' + mentionedChannel.getName());
            }
            for (Role mentionedRole : this.mentionedRoles) {
                tmp = tmp.replace("<@&" + mentionedRole.getId() + '>', '@' + mentionedRole.getName());
            }
            for (Emote emote : this.emotes) {
                tmp = tmp.replace(emote.getAsEmote(), ":" + emote.getName() + ":");
            }
            this.subContent = tmp;
        }
        return this.subContent;
    }

    @Override
    public String getRawContent() {
        return this.content;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public MessageChannel getChannel() {
        return this.isPrivate() ? this.api.getPrivateChannelById(this.channelId) : this.api.getTextChannelById(this.channelId);
    }

    @Override
    public List<Message.Attachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    @Override
    public List<MessageEmbed> getEmbeds() {
        return Collections.unmodifiableList(this.embeds);
    }

    @Override
    public List<Emote> getEmotes() {
        return Collections.unmodifiableList(this.emotes);
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public boolean isTTS() {
        return this.isTTS;
    }

    @Override
    public Message updateMessage(String newContent) {
        if (this.api.getSelfInfo() != this.getAuthor()) {
            throw new UnsupportedOperationException("Attempted to update message that was not sent by this account. You cannot modify other User's messages!");
        }
        try {
            JSONObject response = this.api.getRequester().patch("https://discordapp.com/api/channels/" + this.channelId + "/messages/" + this.getId(), new JSONObject().put("content", newContent)).getObject();
            if (response == null || !response.has("id")) {
                return null;
            }
            return new EntityBuilder(this.api).createMessage(response);
        }
        catch (JSONException ex) {
            JDAImpl.LOG.log(ex);
            return null;
        }
    }

    @Override
    public void updateMessageAsync(String newContent, Consumer<Message> callback) {
        if (this.api.getSelfInfo() != this.getAuthor()) {
            throw new UnsupportedOperationException("Attempted to update message that was not sent by this account. You cannot modify other User's messages!");
        }
        MessageImpl newMessage = new MessageImpl(this.getId(), this.api).setContent(newContent).setChannelId(this.getChannelId());
        String ratelimitIdentifier = this.isPrivate ? "GLOBAL_PRIV_CHANNEL_RATELIMIT" : this.api.getTextChannelById(this.channelId).getGuild().getId();
        TextChannelImpl.AsyncMessageSender.getInstance(this.api, ratelimitIdentifier).enqueue(newMessage, true, callback);
    }

    @Override
    public void deleteMessage() {
        Requester.Response response;
        if (this.api.getSelfInfo() != this.getAuthor()) {
            if (this.isPrivate()) {
                throw new PermissionException("Cannot delete another User's messages in a PrivateChannel.");
            }
            if (!this.api.getTextChannelById(this.getChannelId()).checkPermission(this.api.getSelfInfo(), Permission.MESSAGE_MANAGE)) {
                throw new PermissionException(Permission.MESSAGE_MANAGE);
            }
        }
        if ((response = this.api.getRequester().delete("https://discordapp.com/api/channels/" + this.channelId + "/messages/" + this.getId())).isRateLimit()) {
            throw new RateLimitedException(response.getObject().getInt("retry_after"));
        }
    }

    public MessageImpl setMentionedUsers(List<User> mentionedUsers) {
        this.mentionedUsers = mentionedUsers;
        return this;
    }

    public MessageImpl setMentionedChannels(List<TextChannel> mentionedChannels) {
        this.mentionedChannels = mentionedChannels;
        return this;
    }

    public MessageImpl setMentionedRoles(List<Role> mentionedRoles) {
        this.mentionedRoles = mentionedRoles;
        return this;
    }

    public MessageImpl setMentionsEveryone(boolean mentionsEveryone) {
        this.mentionsEveryone = mentionsEveryone;
        return this;
    }

    public MessageImpl setTTS(boolean TTS) {
        this.isTTS = TTS;
        return this;
    }

    public MessageImpl setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public MessageImpl setEditedTime(OffsetDateTime editedTime) {
        this.editedTime = editedTime;
        return this;
    }

    public MessageImpl setAuthor(User author) {
        this.author = author;
        return this;
    }

    public MessageImpl setIsPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        return this;
    }

    public MessageImpl setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    public MessageImpl setContent(String content) {
        this.content = content;
        return this;
    }

    public MessageImpl setAttachments(List<Message.Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public MessageImpl setEmbeds(List<MessageEmbed> embeds) {
        this.embeds = embeds;
        return this;
    }

    public MessageImpl setEmotes(List<Emote> emotes) {
        this.emotes = emotes;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Message)) {
            return false;
        }
        Message oMsg = (Message)o;
        return this == oMsg || this.getId().equals(oMsg.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        String content = this.getContent();
        if (content.length() > 20) {
            content = content.substring(0, 17) + "...";
        }
        return "M:" + this.author.getUsername() + ':' + content + '(' + this.getId() + ')';
    }

    @Override
    public String getStrippedContent() {
        if (this.strippedContent == null) {
            String tmp = this.getContent();
            String[] keys = new String[]{"*", "_", "`", "~~"};
            TreeSet<FormatToken> tokens = new TreeSet<FormatToken>((t1, t2) -> Integer.compare(t1.start, t2.start));
            for (String key : keys) {
                Matcher matcher = Pattern.compile(Pattern.quote(key)).matcher(tmp);
                while (matcher.find()) {
                    tokens.add(new FormatToken(key, matcher.start()));
                }
            }
            Stack<FormatToken> stack = new Stack<FormatToken>();
            ArrayList toRemove = new ArrayList();
            boolean inBlock = false;
            for (FormatToken token : tokens) {
                if (stack.empty() || !((FormatToken)stack.peek()).format.equals(token.format) || ((FormatToken)stack.peek()).start + token.format.length() == token.start) {
                    if (!inBlock) {
                        if (token.format.equals("`")) {
                            stack.clear();
                            inBlock = true;
                        }
                        stack.push(token);
                        continue;
                    }
                    if (!token.format.equals("`")) continue;
                    stack.push(token);
                    continue;
                }
                if (stack.empty()) continue;
                toRemove.add(stack.pop());
                toRemove.add(token);
                if (!token.format.equals("`") || !stack.empty()) continue;
                inBlock = false;
            }
            Collections.sort(toRemove, (t1, t2) -> Integer.compare(t1.start, t2.start));
            StringBuilder out = new StringBuilder();
            int currIndex = 0;
            for (FormatToken formatToken : toRemove) {
                if (currIndex < formatToken.start) {
                    out.append(tmp.substring(currIndex, formatToken.start));
                }
                currIndex = formatToken.start + formatToken.format.length();
            }
            if (currIndex < tmp.length()) {
                out.append(tmp.substring(currIndex));
            }
            this.strippedContent = out.toString().replace("*", "\\*").replace("_", "\\_").replace("~", "\\~");
        }
        return this.strippedContent;
    }

    private static class FormatToken {
        public final String format;
        public final int start;

        public FormatToken(String format, int start) {
            this.format = format;
            this.start = start;
        }
    }
}

