/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.audio.player;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.dv8tion.jda.audio.AudioSendHandler;
import net.dv8tion.jda.utils.SimpleLog;
import org.tritonus.dsp.ais.AmplitudeAudioInputStream;

public abstract class Player
implements AudioSendHandler {
    protected AudioInputStream audioSource = null;
    protected AudioFormat audioFormat = null;
    protected AmplitudeAudioInputStream amplitudeAudioStream = null;
    protected float amplitude = 1.0f;

    public abstract void play();

    public abstract void pause();

    public abstract void stop();

    public abstract void restart();

    public abstract boolean isStarted();

    public abstract boolean isPlaying();

    public abstract boolean isPaused();

    public abstract boolean isStopped();

    public void setAudioSource(AudioInputStream inSource) {
        if (inSource == null) {
            throw new IllegalArgumentException("Cannot create an audio player from a null AudioInputStream!");
        }
        if (this.audioSource != null) {
            try {
                this.audioSource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AudioFormat baseFormat = inSource.getFormat();
        AudioFormat toPCM = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), baseFormat.getSampleSizeInBits() != -1 ? baseFormat.getSampleSizeInBits() : 16, baseFormat.getChannels(), baseFormat.getFrameSize() != -1 ? baseFormat.getFrameSize() : 2 * baseFormat.getChannels(), baseFormat.getFrameRate() != -1.0f ? baseFormat.getFrameRate() : baseFormat.getSampleRate(), baseFormat.isBigEndian());
        AudioInputStream pcmStream = AudioSystem.getAudioInputStream(toPCM, inSource);
        this.audioFormat = new AudioFormat(toPCM.getEncoding(), 48000.0f, toPCM.getSampleSizeInBits(), toPCM.getChannels(), toPCM.getFrameSize(), 48000.0f, true);
        this.amplitudeAudioStream = new AmplitudeAudioInputStream(pcmStream);
        this.amplitudeAudioStream.setAmplitudeLinear(this.amplitude);
        this.audioSource = AudioSystem.getAudioInputStream(this.audioFormat, (AudioInputStream)this.amplitudeAudioStream);
    }

    public void setVolume(float volume) {
        this.amplitude = volume;
        if (this.amplitudeAudioStream != null) {
            this.amplitudeAudioStream.setAmplitudeLinear(this.amplitude);
        }
    }

    @Override
    public boolean canProvide() {
        return !this.isPaused() && !this.isStopped();
    }

    @Override
    public byte[] provide20MsAudio() {
        if (this.audioSource == null || this.audioFormat == null) {
            throw new IllegalStateException("The Audio source was never set for this player!\nPlease provide an AudioInputStream using setAudioSource.");
        }
        try {
            byte[] audio = new byte[960 * this.audioFormat.getFrameSize()];
            int amountRead = this.audioSource.read(audio, 0, audio.length);
            if (amountRead > -1) {
                return audio;
            }
            this.stop();
            this.audioSource.close();
            return null;
        }
        catch (IOException e) {
            SimpleLog.getLog("JDAPlayer").log(e);
            return new byte[0];
        }
    }
}

