/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.audio;

import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.entities.User;

public class CombinedAudio {
    protected List<User> users;
    protected short[] audioData;

    public CombinedAudio(List<User> users, short[] audioData) {
        this.users = Collections.unmodifiableList(users);
        this.audioData = audioData;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public byte[] getAudioData(double volume) {
        int byteIndex = 0;
        byte[] audio = new byte[this.audioData.length * 2];
        for (int i = 0; i < this.audioData.length; ++i) {
            short s = this.audioData[i];
            if (volume != 1.0) {
                s = (short)((double)s * volume);
            }
            byte leftByte = (byte)(0xFF & s >> 8);
            byte rightByte = (byte)(0xFF & s);
            audio[byteIndex] = leftByte;
            audio[byteIndex + 1] = rightByte;
            byteIndex += 2;
        }
        return audio;
    }
}

