/*
 * Decompiled with CFR 0.152.
 */
package com.neovisionaries.ws.client;

import com.neovisionaries.ws.client.ByteArray;
import com.neovisionaries.ws.client.FixedDistanceHuffman;
import com.neovisionaries.ws.client.FixedLiteralLengthHuffman;
import com.neovisionaries.ws.client.FormatException;
import com.neovisionaries.ws.client.Huffman;

class DeflateDecompressor {
    private static int[] INDICES_FROM_CODE_LENGTH_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};

    DeflateDecompressor() {
    }

    public static void decompress(ByteArray input, int index, ByteArray output) throws FormatException {
        int[] bitIndex = new int[]{index * 8};
        while (DeflateDecompressor.inflateBlock(input, bitIndex, output)) {
        }
    }

    private static boolean getBit(ByteArray input, int bitIndex) {
        int index = bitIndex / 8;
        int shift = bitIndex % 8;
        byte value = input.get(index);
        return (value & 1 << shift) != 0;
    }

    private static int getBits(ByteArray input, int bitIndex, int nBits) {
        int number = 0;
        int weight = 1;
        int i = 0;
        while (i < nBits) {
            if (DeflateDecompressor.getBit(input, bitIndex + i)) {
                number += weight;
            }
            ++i;
            weight *= 2;
        }
        return number;
    }

    private static boolean readBit(ByteArray input, int[] bitIndex) {
        boolean result = DeflateDecompressor.getBit(input, bitIndex[0]);
        bitIndex[0] = bitIndex[0] + 1;
        return result;
    }

    private static int readBits(ByteArray input, int[] bitIndex, int nBits) {
        int number = DeflateDecompressor.getBits(input, bitIndex[0], nBits);
        bitIndex[0] = bitIndex[0] + nBits;
        return number;
    }

    private static boolean inflateBlock(ByteArray input, int[] bitIndex, ByteArray output) throws FormatException {
        boolean last = DeflateDecompressor.readBit(input, bitIndex);
        int type = DeflateDecompressor.readBits(input, bitIndex, 2);
        switch (type) {
            case 0: {
                last |= DeflateDecompressor.inflatePlainBlock(input, bitIndex, output);
                break;
            }
            case 1: {
                DeflateDecompressor.inflateFixedBlock(input, bitIndex, output);
                break;
            }
            case 2: {
                DeflateDecompressor.inflateDynamicBlock(input, bitIndex, output);
                break;
            }
            default: {
                String message = String.format("[%s] Bad compression type '11' at the bit index '%d'.", DeflateDecompressor.class.getSimpleName(), bitIndex[0]);
                throw new FormatException(message);
            }
        }
        return !last;
    }

    private static boolean inflatePlainBlock(ByteArray input, int[] bitIndex, ByteArray output) {
        int bi = bitIndex[0] + 7 & 0xFFFFFFF8;
        int index = bi / 8;
        int len = (input.get(index) & 0xFF) + (input.get(index + 1) & 0xFF) * 256;
        output.put(input, index += 4, len);
        bitIndex[0] = (index + len) * 8;
        return len == 0;
    }

    private static void inflateFixedBlock(ByteArray input, int[] bitIndex, ByteArray output) throws FormatException {
        DeflateDecompressor.inflateData(input, bitIndex, output, FixedLiteralLengthHuffman.getInstance(), FixedDistanceHuffman.getInstance());
    }

    private static void inflateDynamicBlock(ByteArray input, int[] bitIndex, ByteArray output) throws FormatException {
        int hlit = DeflateDecompressor.readBits(input, bitIndex, 5) + 257;
        int hdist = DeflateDecompressor.readBits(input, bitIndex, 5) + 1;
        int hclen = DeflateDecompressor.readBits(input, bitIndex, 4) + 4;
        int[] codeLengthsFromCodeLengthValue = new int[19];
        for (int i = 0; i < hclen; ++i) {
            byte codeLengthOfCodeLengthValue = (byte)DeflateDecompressor.readBits(input, bitIndex, 3);
            int index = DeflateDecompressor.codeLengthOrderToIndex(i);
            codeLengthsFromCodeLengthValue[index] = codeLengthOfCodeLengthValue;
        }
        Huffman codeLengthHuffman = new Huffman(codeLengthsFromCodeLengthValue);
        int[] codeLengthsFromLiteralLengthCode = new int[hlit];
        DeflateDecompressor.readCodeLengths(input, bitIndex, codeLengthsFromLiteralLengthCode, codeLengthHuffman);
        Huffman literalLengthHuffman = new Huffman(codeLengthsFromLiteralLengthCode);
        int[] codeLengthsFromDistanceCode = new int[hdist];
        DeflateDecompressor.readCodeLengths(input, bitIndex, codeLengthsFromDistanceCode, codeLengthHuffman);
        Huffman distanceHuffman = new Huffman(codeLengthsFromDistanceCode);
        DeflateDecompressor.inflateData(input, bitIndex, output, literalLengthHuffman, distanceHuffman);
    }

    private static void inflateData(ByteArray input, int[] bitIndex, ByteArray output, Huffman literalLengthHuffman, Huffman distanceHuffman) throws FormatException {
        int literalLength;
        while ((literalLength = literalLengthHuffman.readSym(input, bitIndex)) != 256) {
            if (0 <= literalLength && literalLength <= 255) {
                output.put(literalLength);
                continue;
            }
            int length = DeflateDecompressor.readLength(input, bitIndex, literalLength);
            int distance = DeflateDecompressor.readDistance(input, bitIndex, distanceHuffman);
            DeflateDecompressor.duplicate(length, distance, output);
        }
    }

    private static int codeLengthOrderToIndex(int order) {
        return INDICES_FROM_CODE_LENGTH_ORDER[order];
    }

    private static void readCodeLengths(ByteArray input, int[] bitIndex, int[] codeLengths, Huffman codeLengthHuffman) throws FormatException {
        for (int i = 0; i < codeLengths.length; ++i) {
            int repeatCount;
            int codeLength = codeLengthHuffman.readSym(input, bitIndex);
            if (0 <= codeLength && codeLength <= 15) {
                codeLengths[i] = codeLength;
                continue;
            }
            switch (codeLength) {
                case 16: {
                    codeLength = codeLengths[i - 1];
                    repeatCount = DeflateDecompressor.readBits(input, bitIndex, 2) + 3;
                    break;
                }
                case 17: {
                    codeLength = 0;
                    repeatCount = DeflateDecompressor.readBits(input, bitIndex, 3) + 3;
                    break;
                }
                case 18: {
                    codeLength = 0;
                    repeatCount = DeflateDecompressor.readBits(input, bitIndex, 7) + 11;
                    break;
                }
                default: {
                    String message = String.format("[%s] Bad code length '%d' at the bit index '%d'.", DeflateDecompressor.class.getSimpleName(), codeLength, bitIndex);
                    throw new FormatException(message);
                }
            }
            for (int j = 0; j < repeatCount; ++j) {
                codeLengths[i + j] = codeLength;
            }
            i += repeatCount - 1;
        }
    }

    private static int readLength(ByteArray input, int[] bitIndex, int literalLength) throws FormatException {
        int nBits;
        int baseValue;
        switch (literalLength) {
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: {
                return literalLength - 254;
            }
            case 265: {
                baseValue = 11;
                nBits = 1;
                break;
            }
            case 266: {
                baseValue = 13;
                nBits = 1;
                break;
            }
            case 267: {
                baseValue = 15;
                nBits = 1;
                break;
            }
            case 268: {
                baseValue = 17;
                nBits = 1;
                break;
            }
            case 269: {
                baseValue = 19;
                nBits = 2;
                break;
            }
            case 270: {
                baseValue = 23;
                nBits = 2;
                break;
            }
            case 271: {
                baseValue = 27;
                nBits = 2;
                break;
            }
            case 272: {
                baseValue = 31;
                nBits = 2;
                break;
            }
            case 273: {
                baseValue = 35;
                nBits = 3;
                break;
            }
            case 274: {
                baseValue = 43;
                nBits = 3;
                break;
            }
            case 275: {
                baseValue = 51;
                nBits = 3;
                break;
            }
            case 276: {
                baseValue = 59;
                nBits = 3;
                break;
            }
            case 277: {
                baseValue = 67;
                nBits = 4;
                break;
            }
            case 278: {
                baseValue = 83;
                nBits = 4;
                break;
            }
            case 279: {
                baseValue = 99;
                nBits = 4;
                break;
            }
            case 280: {
                baseValue = 115;
                nBits = 4;
                break;
            }
            case 281: {
                baseValue = 131;
                nBits = 5;
                break;
            }
            case 282: {
                baseValue = 163;
                nBits = 5;
                break;
            }
            case 283: {
                baseValue = 195;
                nBits = 5;
                break;
            }
            case 284: {
                baseValue = 227;
                nBits = 5;
                break;
            }
            case 285: {
                return 258;
            }
            default: {
                String message = String.format("[%s] Bad literal/length code '%d' at the bit index '%d'.", DeflateDecompressor.class.getSimpleName(), literalLength, bitIndex[0]);
                throw new FormatException(message);
            }
        }
        int n = DeflateDecompressor.readBits(input, bitIndex, nBits);
        return baseValue + n;
    }

    private static int readDistance(ByteArray input, int[] bitIndex, Huffman distanceHuffman) throws FormatException {
        int nBits;
        int baseValue;
        int code = distanceHuffman.readSym(input, bitIndex);
        switch (code) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return code + 1;
            }
            case 4: {
                baseValue = 5;
                nBits = 1;
                break;
            }
            case 5: {
                baseValue = 7;
                nBits = 1;
                break;
            }
            case 6: {
                baseValue = 9;
                nBits = 2;
                break;
            }
            case 7: {
                baseValue = 13;
                nBits = 2;
                break;
            }
            case 8: {
                baseValue = 17;
                nBits = 3;
                break;
            }
            case 9: {
                baseValue = 25;
                nBits = 3;
                break;
            }
            case 10: {
                baseValue = 33;
                nBits = 4;
                break;
            }
            case 11: {
                baseValue = 49;
                nBits = 4;
                break;
            }
            case 12: {
                baseValue = 65;
                nBits = 5;
                break;
            }
            case 13: {
                baseValue = 97;
                nBits = 5;
                break;
            }
            case 14: {
                baseValue = 129;
                nBits = 6;
                break;
            }
            case 15: {
                baseValue = 193;
                nBits = 6;
                break;
            }
            case 16: {
                baseValue = 257;
                nBits = 7;
                break;
            }
            case 17: {
                baseValue = 385;
                nBits = 7;
                break;
            }
            case 18: {
                baseValue = 513;
                nBits = 8;
                break;
            }
            case 19: {
                baseValue = 769;
                nBits = 8;
                break;
            }
            case 20: {
                baseValue = 1025;
                nBits = 9;
                break;
            }
            case 21: {
                baseValue = 1537;
                nBits = 9;
                break;
            }
            case 22: {
                baseValue = 2049;
                nBits = 10;
                break;
            }
            case 23: {
                baseValue = 3073;
                nBits = 10;
                break;
            }
            case 24: {
                baseValue = 4097;
                nBits = 11;
                break;
            }
            case 25: {
                baseValue = 6145;
                nBits = 11;
                break;
            }
            case 26: {
                baseValue = 8193;
                nBits = 12;
                break;
            }
            case 27: {
                baseValue = 12289;
                nBits = 12;
                break;
            }
            case 28: {
                baseValue = 16385;
                nBits = 13;
                break;
            }
            case 29: {
                baseValue = 24577;
                nBits = 13;
                break;
            }
            default: {
                String message = String.format("[%s] Bad distance code '%d' at the bit index '%d'.", DeflateDecompressor.class.getSimpleName(), code, bitIndex[0]);
                throw new FormatException(message);
            }
        }
        int n = DeflateDecompressor.readBits(input, bitIndex, nBits);
        return baseValue + n;
    }

    private static void duplicate(int length, int distance, ByteArray output) {
        int initialPosition;
        int sourceLength = output.length();
        byte[] target = new byte[length];
        int sourceIndex = initialPosition = sourceLength - distance;
        int targetIndex = 0;
        while (targetIndex < length) {
            if (sourceLength <= sourceIndex) {
                sourceIndex = initialPosition;
            }
            target[targetIndex] = output.get(sourceIndex);
            ++targetIndex;
            ++sourceIndex;
        }
        output.put(target);
    }
}

