/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.sampled.convert.LawEncoder;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

public class LawDecoder
extends TEncodingFormatConversionProvider {
    private static final AudioFormat[] INPUT_FORMATS = LawEncoder.LAW_FORMATS;
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true)};

    public LawDecoder() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (AudioFormats.matches(sourceFormat, targetFormat)) {
            return sourceStream;
        }
        if (LawDecoder.doMatch(targetFormat.getFrameRate(), sourceFormat.getFrameRate()) && LawDecoder.doMatch(targetFormat.getChannels(), sourceFormat.getChannels()) && LawDecoder.doMatch(sourceFormat.getSampleSizeInBits(), 8)) {
            if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                return new FromUlawStream(sourceStream, targetFormat);
            }
            if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                return new FromAlawStream(sourceStream, targetFormat);
            }
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    private static final AudioFormat createTargetFormat(AudioFormat src, AudioFormat dst) {
        return new AudioFormat(dst.getEncoding(), src.getSampleRate(), dst.getSampleSizeInBits(), src.getChannels(), dst.getSampleSizeInBits() * src.getChannels() / 8, src.getFrameRate(), dst.isBigEndian());
    }

    class FromAlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public FromAlawStream(AudioInputStream sourceStream, AudioFormat targetFormat) {
            super(sourceStream, LawDecoder.createTargetFormat(sourceStream.getFormat(), targetFormat));
            this.convertType = LawEncoder.getConvertType(this.getFormat(), 5);
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
            if (targetFormat.getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
        }

        @Override
        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.alaw2pcm8(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.alaw2pcm8(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 3: {
                    TConversionTool.alaw2pcm16(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 4: {
                    TConversionTool.alaw2pcm16(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 6: {
                    TConversionTool.alaw2ulaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                }
            }
            return inFrameCount;
        }

        @Override
        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.format.getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.alaw2pcm8(buffer, byteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.alaw2pcm8(buffer, byteOffset, sampleCount, true);
                    break;
                }
                case 6: {
                    TConversionTool.alaw2ulaw(buffer, byteOffset, sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("FromAlawStream: Call to convertInPlace, but it cannot convert in place. (convertType=" + this.convertType + ")");
                }
            }
        }
    }

    class FromUlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public FromUlawStream(AudioInputStream sourceStream, AudioFormat targetFormat) {
            super(sourceStream, LawDecoder.createTargetFormat(sourceStream.getFormat(), targetFormat));
            this.convertType = LawEncoder.getConvertType(this.getFormat(), 6);
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
            if (targetFormat.getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
        }

        @Override
        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.ulaw2pcm8(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.ulaw2pcm8(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 3: {
                    TConversionTool.ulaw2pcm16(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 4: {
                    TConversionTool.ulaw2pcm16(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 5: {
                    TConversionTool.ulaw2alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                }
            }
            return inFrameCount;
        }

        @Override
        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.format.getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.ulaw2pcm8(buffer, byteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.ulaw2pcm8(buffer, byteOffset, sampleCount, true);
                    break;
                }
                case 5: {
                    TConversionTool.ulaw2alaw(buffer, byteOffset, sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("FromUlawStream: Call to convertInPlace, but it cannot convert in place. (convertType=" + this.convertType + ")");
                }
            }
        }
    }
}

