/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import sun.net.spi.nameservice.dns.DNSNameService;

public class ServiceUtil {
    public static final Map<Class, List<String>> SERVICES;
    public static final String SERVICES_DIRECTORY = "META-INF/services/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadServices() {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            File servicesJar = Files.createTempFile("jda-services", ".jar", new FileAttribute[0]).toFile();
            servicesJar.deleteOnExit();
            fos = new FileOutputStream(servicesJar);
            zos = new JarOutputStream(fos);
            for (Map.Entry<Class, List<String>> service : SERVICES.entrySet()) {
                String fileName = SERVICES_DIRECTORY + service.getKey().getCanonicalName();
                ZipEntry zipEntry = new ZipEntry(fileName);
                ((JarOutputStream)zos).putNextEntry(zipEntry);
                for (String provider : service.getValue()) {
                    zos.write((provider + "\n").getBytes());
                }
                zos.closeEntry();
            }
            zos.close();
            fos.close();
            ClassLoader extentionLoader = DNSNameService.class.getClassLoader();
            Method addExtUrl = extentionLoader.getClass().getDeclaredMethod("addExtURL", URL.class);
            addExtUrl.setAccessible(true);
            addExtUrl.invoke((Object)extentionLoader, servicesJar.toURI().toURL());
            for (Class service : SERVICES.keySet()) {
                ServiceLoader loader = ServiceLoader.load(service);
                loader.reload();
            }
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        HashMap<Class<MidiFileReader>, List<String>> services = new HashMap<Class<MidiFileReader>, List<String>>();
        services.put(FormatConversionProvider.class, Collections.unmodifiableList(Arrays.asList("javazoom.spi.mpeg.sampled.convert.MpegFormatConversionProvider", "org.tritonus.sampled.convert.LawEncoder", "org.tritonus.sampled.convert.LawDecoder", "org.tritonus.sampled.convert.PCM2PCMConversionProvider", "org.tritonus.sampled.convert.SampleRateConversionProvider", "org.tritonus.sampled.convert.ImaAdpcmFormatConversionProvider", "org.kc7bfi.jflac.sound.spi.FlacFormatConversionProvider")));
        services.put(AudioFileReader.class, Collections.unmodifiableList(Arrays.asList("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader", "org.tritonus.sampled.file.AuAudioFileReader", "org.tritonus.sampled.file.WaveAudioFileReader", "org.tritonus.sampled.file.AiffAudioFileReader", "net.sourceforge.jaad.spi.javasound.AACAudioFileReader", "org.kc7bfi.jflac.sound.spi.FlacAudioFileReader")));
        services.put(AudioFileWriter.class, Collections.unmodifiableList(Arrays.asList("org.tritonus.sampled.file.AuAudioFileWriter", "org.tritonus.sampled.file.WaveAudioFileWriter", "org.tritonus.sampled.file.AiffAudioFileWriter")));
        services.put(MidiFileWriter.class, Collections.unmodifiableList(Collections.singletonList("org.tritonus.midi.file.StandardMidiFileWriter")));
        services.put(MidiFileReader.class, Collections.unmodifiableList(Collections.singletonList("org.tritonus.midi.file.StandardMidiFileReader")));
        SERVICES = Collections.unmodifiableMap(services);
    }
}

