/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.utils;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Channel;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.utils.PermissionUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class InviteUtil {
    public static Invite resolve(String code) {
        JSONObject object;
        if (code == null) {
            throw new NullPointerException("The provided invite code/url was null.");
        }
        if (code.startsWith("http")) {
            String[] split = code.split("/");
            code = split[split.length - 1];
        }
        if ((object = new JDAImpl(false, false, false).getRequester().get("https://discordapp.com/api/invite/" + code).getObject()) != null && object.has("code") && object.has("guild")) {
            JSONObject guild = object.getJSONObject("guild");
            JSONObject channel = object.getJSONObject("channel");
            return new Invite(object.getString("code"), guild.getString("name"), guild.getString("id"), channel.getString("name"), channel.getString("id"), channel.getString("type").equals("text"));
        }
        return null;
    }

    public static AdvancedInvite createInvite(Channel chan) {
        return InviteUtil.createInvite(chan, InviteDuration.ONE_DAY, 0, false);
    }

    public static AdvancedInvite createInvite(Channel chan, InviteDuration duration, int maxUses, boolean temporary) {
        JDA jda = chan.getJDA();
        if (!chan.checkPermission(jda.getSelfInfo(), Permission.CREATE_INSTANT_INVITE)) {
            throw new PermissionException(Permission.CREATE_INSTANT_INVITE);
        }
        maxUses = Math.max(0, maxUses);
        JSONObject object = ((JDAImpl)jda).getRequester().post("https://discordapp.com/api/channels/" + chan.getId() + "/invites", new JSONObject().put("max_age", duration.getDuration()).put("temporary", temporary).put("max_uses", maxUses)).getObject();
        if (object != null && object.has("code")) {
            return AdvancedInvite.fromJson(object, jda);
        }
        return null;
    }

    public static void delete(Invite invite, JDA jda) {
        Channel channel = invite.isTextChannel ? jda.getTextChannelById(invite.getChannelId()) : jda.getVoiceChannelById(invite.getChannelId());
        if (channel == null || !channel.checkPermission(jda.getSelfInfo(), Permission.MANAGE_CHANNEL)) {
            throw new PermissionException(Permission.MANAGE_CHANNEL, "JDA cannot delete the invite because the currently logged in account does not have permission");
        }
        ((JDAImpl)jda).getRequester().delete("https://discordapp.com/api/invite/" + invite.getCode());
    }

    public static void delete(String code, JDA jda) {
        Invite invite = InviteUtil.resolve(code);
        if (invite == null) {
            throw new IllegalArgumentException("The provided Invite code was invalid, thus JDA cannot attemptto delete it! Provided Code: " + code);
        }
        InviteUtil.delete(invite, jda);
    }

    public static List<AdvancedInvite> getInvites(Guild guildObj) {
        if (!PermissionUtil.checkPermission((User)guildObj.getJDA().getSelfInfo(), Permission.MANAGE_SERVER, guildObj)) {
            throw new PermissionException(Permission.MANAGE_SERVER);
        }
        ArrayList<AdvancedInvite> invites = new ArrayList<AdvancedInvite>();
        JSONArray array = ((JDAImpl)guildObj.getJDA()).getRequester().get("https://discordapp.com/api/guilds/" + guildObj.getId() + "/invites").getArray();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject invite = array.getJSONObject(i);
                if (!invite.has("code")) continue;
                invites.add(AdvancedInvite.fromJson(invite, guildObj.getJDA()));
            }
        }
        return Collections.unmodifiableList(invites);
    }

    public static List<AdvancedInvite> getInvites(Channel channelObj) {
        if (!PermissionUtil.checkPermission((User)channelObj.getJDA().getSelfInfo(), Permission.MANAGE_CHANNEL, channelObj)) {
            throw new PermissionException(Permission.MANAGE_CHANNEL);
        }
        ArrayList<AdvancedInvite> invites = new ArrayList<AdvancedInvite>();
        JSONArray array = ((JDAImpl)channelObj.getJDA()).getRequester().get("https://discordapp.com/api/channels/" + channelObj.getId() + "/invites").getArray();
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                JSONObject invite = array.getJSONObject(i);
                if (!invite.has("code")) continue;
                invites.add(AdvancedInvite.fromJson(invite, channelObj.getJDA()));
            }
        }
        return Collections.unmodifiableList(invites);
    }

    public static enum InviteDuration {
        INFINITE(0),
        THIRTY_MINUTES(1800),
        ONE_HOUR(3600),
        SIX_HOURS(21600),
        TWELVE_HOURS(43200),
        ONE_DAY(86400);

        private final int duration;

        private InviteDuration(int duration) {
            this.duration = duration;
        }

        private int getDuration() {
            return this.duration;
        }

        private static InviteDuration getFromDuration(int duration) {
            for (InviteDuration dur : InviteDuration.values()) {
                if (dur.getDuration() != duration) continue;
                return dur;
            }
            return INFINITE;
        }
    }

    public static class AdvancedInvite
    extends Invite {
        private final InviteDuration duration;
        private final String guildSplashHash;
        private final boolean temporary;
        private final int maxUses;
        private final OffsetDateTime createdAt;
        private final int uses;
        private final User inviter;

        private AdvancedInvite(String code, String guildName, String guildId, String channelName, String channelId, boolean isTextChannel, InviteDuration duration, String guildSplashHash, boolean temporary, int maxUses, OffsetDateTime createdAt, int uses, User inviter) {
            super(code, guildName, guildId, channelName, channelId, isTextChannel);
            this.duration = duration;
            this.guildSplashHash = guildSplashHash;
            this.temporary = temporary;
            this.maxUses = maxUses;
            this.createdAt = createdAt;
            this.uses = uses;
            this.inviter = inviter;
        }

        public InviteDuration getDuration() {
            return this.duration;
        }

        public String getGuildSplashHash() {
            return this.guildSplashHash;
        }

        public boolean isTemporary() {
            return this.temporary;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public OffsetDateTime getCreatedAt() {
            return this.createdAt;
        }

        public int getUses() {
            return this.uses;
        }

        public User getInviter() {
            return this.inviter;
        }

        private static AdvancedInvite fromJson(JSONObject object, JDA jda) {
            JSONObject guild = object.getJSONObject("guild");
            JSONObject channel = object.getJSONObject("channel");
            JSONObject inviter = object.getJSONObject("inviter");
            return new AdvancedInvite(object.getString("code"), guild.getString("name"), guild.getString("id"), channel.getString("name"), channel.getString("id"), channel.getString("type").equals("text"), InviteDuration.getFromDuration(object.getInt("max_age")), guild.isNull("splash_hash") ? null : guild.getString("splash_hash"), object.getBoolean("temporary"), object.getInt("max_uses"), OffsetDateTime.parse(object.getString("created_at")), object.getInt("uses"), jda.getUserById(inviter.getString("id")));
        }
    }

    public static class Invite {
        private final String code;
        private final String guildName;
        private final String guildId;
        private final String channelName;
        private final String channelId;
        private final boolean isTextChannel;

        private Invite(String code, String guildName, String guildId, String channelName, String channelId, boolean isTextChannel) {
            this.code = code;
            this.guildName = guildName;
            this.guildId = guildId;
            this.channelName = channelName;
            this.channelId = channelId;
            this.isTextChannel = isTextChannel;
        }

        public String getCode() {
            return this.code;
        }

        public String getGuildName() {
            return this.guildName;
        }

        public String getGuildId() {
            return this.guildId;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public boolean isTextChannel() {
            return this.isTextChannel;
        }
    }
}

