/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.utils;

import java.util.HashSet;
import java.util.Set;
import javax.security.auth.login.LoginException;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.requests.Requester;
import net.dv8tion.jda.utils.AvatarUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApplicationUtil {
    private final JDAImpl api = new JDAImpl(false, false, false);

    public static String getApplicationId(JDA jda) {
        Requester.Response response = ((JDAImpl)jda).getRequester().get("https://discordapp.com/api/oauth2/applications/@me");
        if (response.isOk()) {
            return response.getObject().getString("id");
        }
        JDAImpl.LOG.debug("Fetching Application-id failed. Response: " + response.toString());
        return null;
    }

    public static String getAuthInvite(String appId, Permission ... perms) {
        int perm = 0;
        for (Permission permission : perms) {
            perm |= 1 << permission.getOffset();
        }
        return "https://discordapp.com/oauth2/authorize?client_id=" + appId + "&scope=bot&permissions=" + perm;
    }

    public static String getAuthInvite(JDA jda, Permission ... perms) {
        String applicationId = ApplicationUtil.getApplicationId(jda);
        return applicationId == null ? null : ApplicationUtil.getAuthInvite(applicationId, perms);
    }

    public ApplicationUtil(String token) throws LoginException {
        this.api.verifyToken(token);
    }

    public Set<Application> getApplications() {
        Requester.Response response = this.api.getRequester().get("https://discordapp.com/api/oauth2/applications");
        HashSet<Application> apps = new HashSet<Application>();
        if (response.isOk()) {
            JSONArray array = response.getArray();
            for (int i = 0; i < array.length(); ++i) {
                apps.add(new Application(array.getJSONObject(i)));
            }
        }
        return apps;
    }

    public Application getApplication(String id) {
        Requester.Response response = this.api.getRequester().get("https://discordapp.com/api/oauth2/applications/" + id);
        if (response.isOk()) {
            return new Application(response.getObject());
        }
        return null;
    }

    public Application createApplication(String appName) {
        Requester.Response response = this.api.getRequester().post("https://discordapp.com/api/oauth2/applications", new JSONObject().put("name", appName));
        if (response.isOk()) {
            return new Application(response.getObject());
        }
        throw new RuntimeException("Error creating a new Application: " + response.toString());
    }

    public class Application {
        private String id;
        private String name;
        private String description;
        private String secret;
        private String iconId;
        private Bot bot;
        private final JSONArray redirects;

        private Application(JSONObject obj) {
            this.redirects = obj.getJSONArray("redirect_uris");
            this.parseFromJson(obj);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            if (newName == null || newName.trim().length() == 0) {
                throw new RuntimeException("Can't update Application-name to null / empty string!");
            }
            this.updateApp(this.getFrame().put("name", newName));
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String desc) {
            if (desc == null) {
                throw new RuntimeException("Can't update Application-description to null!");
            }
            this.updateApp(this.getFrame().put("description", desc));
        }

        public String getSecret() {
            return this.secret;
        }

        public String getIconId() {
            return this.iconId;
        }

        public void setIcon(AvatarUtil.Avatar newIcon) {
            this.updateApp(this.getFrame().put("icon", newIcon == null || newIcon == AvatarUtil.DELETE_AVATAR ? JSONObject.NULL : newIcon.getEncoded()));
        }

        public String getIconUrl() {
            return this.iconId == null ? null : "https://cdn.discordapp.com/app-icons/" + this.id + '/' + this.iconId + ".jpg";
        }

        public boolean hasBot() {
            return this.bot != null;
        }

        public Bot getBot() {
            return this.bot;
        }

        public Bot createBot() {
            if (this.hasBot()) {
                throw new RuntimeException("Can't create a 2nd Bot for this Application!");
            }
            Requester.Response response = ApplicationUtil.this.api.getRequester().post("https://discordapp.com/api/oauth2/applications/" + this.id + "/bot", new JSONObject());
            if (response.isOk()) {
                JSONObject botO = response.getObject();
                this.bot = new Bot(botO.getString("username"), botO.getString("discriminator"), botO.getString("token"), botO.getString("id"), botO.isNull("avatar") ? null : botO.getString("avatar"));
                return this.bot;
            }
            throw new RuntimeException("Error creating a new Bot: " + response.toString());
        }

        public void delete() {
            Requester.Response response = ApplicationUtil.this.api.getRequester().delete("https://discordapp.com/api/oauth2/applications/" + this.id);
            if (!response.isOk()) {
                throw new RuntimeException("Error deleting the application. Error: " + response.toString());
            }
        }

        private void updateApp(JSONObject o) {
            Requester.Response put = ApplicationUtil.this.api.getRequester().put("https://discordapp.com/api/oauth2/applications/" + this.id, o);
            if (!put.isOk()) {
                throw new RuntimeException("Error updating Application: " + put.toString());
            }
            this.parseFromJson(put.getObject());
        }

        private JSONObject getFrame() {
            return new JSONObject().put("icon", this.iconId).put("description", this.description).put("name", this.name).put("redirect_uris", this.redirects);
        }

        private void parseFromJson(JSONObject o) {
            this.id = o.getString("id");
            this.name = o.getString("name");
            this.description = o.getString("description");
            this.secret = o.getString("secret");
            this.iconId = o.isNull("icon") ? null : o.getString("icon");
            this.bot = null;
            if (o.has("bot")) {
                JSONObject botO = o.getJSONObject("bot");
                this.bot = new Bot(botO.getString("username"), botO.getString("discriminator"), botO.getString("token"), botO.getString("id"), botO.isNull("avatar") ? null : botO.getString("avatar"));
            }
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "Application[" + this.name + '(' + this.id + ')' + (this.hasBot() ? ' ' + this.getBot().toString() : "") + ']';
        }

        public class Bot {
            private String name;
            private String discrim;
            private String token;
            private String id;
            private String avatarId;

            private Bot(String name, String discrim, String token, String id, String avatarId) {
                this.name = name;
                this.discrim = discrim;
                this.token = token;
                this.id = id;
                this.avatarId = avatarId;
            }

            public String getName() {
                return this.name;
            }

            public String getDiscrim() {
                return this.discrim;
            }

            public String getToken() {
                return this.token;
            }

            public String getId() {
                return this.id;
            }

            public String getAvatarId() {
                return this.avatarId;
            }

            public String getAvatarUrl() {
                return this.avatarId == null ? null : "https://cdn.discordapp.com/avatars/" + this.id + "/" + this.avatarId + ".jpg";
            }

            public String getAuthInvite(Permission ... perms) {
                return ApplicationUtil.getAuthInvite(Application.this.id, perms);
            }

            public int hashCode() {
                return this.id.hashCode();
            }

            public String toString() {
                return "Bot[" + this.name + '(' + this.id + ")]";
            }
        }
    }
}

