/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.managers;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.requests.Requester;
import net.dv8tion.jda.utils.PermissionUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class RoleManager {
    private final Role role;
    private String name = null;
    private int color = -1;
    private Boolean grouped = null;
    private Boolean mentionable;
    private int perms;

    public RoleManager(Role role) {
        this.role = role;
        this.perms = role.getPermissionsRaw();
    }

    public Role getRole() {
        return this.role;
    }

    public RoleManager setName(String name) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        this.name = this.role.getName().equals(name) ? null : name;
        return this;
    }

    public RoleManager setPermissionsRaw(int perms) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        for (Permission perm : Permission.getPermissions(perms)) {
            this.checkPermission(perm);
        }
        this.perms = perms;
        return this;
    }

    public RoleManager setColor(int color) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        this.color = color == this.role.getColor() || color < 0 ? -1 : Math.min(0xFFFFFF, color);
        return this;
    }

    public RoleManager setColor(Color color) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        return this.setColor(color == null ? -1 : color.getRGB() & 0xFFFFFF);
    }

    public RoleManager setGrouped(Boolean group) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        this.grouped = group == null || group.booleanValue() == this.role.isGrouped() ? null : group;
        return this;
    }

    public RoleManager setMentionable(Boolean mention) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        this.mentionable = mention == null || mention.booleanValue() == this.role.isMentionable() ? null : mention;
        return this;
    }

    public RoleManager move(int newPosition) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        int maxRolePosition = this.role.getGuild().getRolesForUser(this.role.getJDA().getSelfInfo()).get(0).getPosition();
        if (newPosition >= maxRolePosition) {
            throw new PermissionException("Cannot move to a position equal to or higher than the highest role that you have access to.");
        }
        if (newPosition < 0 || newPosition == this.role.getPosition()) {
            return this;
        }
        HashMap<Integer, Role> newPositions = new HashMap<Integer, Role>();
        Map<Integer, Role> currentPositions = this.role.getGuild().getRoles().stream().collect(Collectors.toMap(role -> role.getPosition(), role -> role));
        currentPositions.remove(-1);
        int searchIndex = newPosition > this.role.getPosition() ? newPosition : newPosition;
        int index = 0;
        for (Role r2 : currentPositions.values()) {
            if (r2 == this.role) continue;
            if (index == searchIndex) {
                newPositions.put(index, this.role);
                ++index;
            }
            newPositions.put(index, r2);
            ++index;
        }
        if (!newPositions.containsValue(this.role)) {
            newPositions.put(newPosition, this.role);
        }
        for (int i = 0; i < newPositions.size(); ++i) {
            if (currentPositions.get(i) != newPositions.get(i)) continue;
            newPositions.remove(i);
        }
        JSONArray rolePositions = new JSONArray();
        newPositions.forEach((pos, r) -> rolePositions.put(new JSONObject().put("id", r.getId()).put("position", pos + 1)));
        ((JDAImpl)this.role.getJDA()).getRequester().patch("https://discordapp.com/api/guilds/" + this.role.getGuild().getId() + "/roles", rolePositions);
        return this;
    }

    public RoleManager give(Permission ... perms) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        for (Permission perm : perms) {
            this.checkPermission(perm);
        }
        for (Permission perm : perms) {
            this.perms |= 1 << perm.getOffset();
        }
        return this;
    }

    public RoleManager revoke(Permission ... perms) {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        for (Permission perm : perms) {
            this.checkPermission(perm);
        }
        for (Permission perm : perms) {
            this.perms &= ~(1 << perm.getOffset());
        }
        return this;
    }

    public void reset() {
        this.name = null;
        this.color = -1;
        this.grouped = null;
        this.perms = this.role.getPermissionsRaw();
    }

    public void update() {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        JSONObject frame = this.getFrame();
        if (this.name != null) {
            frame.put("name", this.name);
        }
        if (this.color >= 0) {
            frame.put("color", this.color);
        }
        if (this.grouped != null) {
            frame.put("hoist", this.grouped);
        }
        if (this.mentionable != null) {
            frame.put("mentionable", this.mentionable);
        }
        this.update(frame);
    }

    public void delete() {
        this.checkPermission(Permission.MANAGE_ROLES);
        this.checkPosition();
        ((JDAImpl)this.role.getJDA()).getRequester().delete("https://discordapp.com/api/guilds/" + this.role.getGuild().getId() + "/roles/" + this.role.getId());
    }

    private JSONObject getFrame() {
        return new JSONObject().put("name", this.role.getName()).put("color", this.role.getColor()).put("hoist", this.role.isGrouped()).put("permissions", this.perms);
    }

    private void update(JSONObject object) {
        Requester.Response response = ((JDAImpl)this.role.getJDA()).getRequester().patch("https://discordapp.com/api/guilds/" + this.role.getGuild().getId() + "/roles/" + this.role.getId(), object);
        if (!response.isOk()) {
            throw new RuntimeException("Setting values of Role " + this.role.getName() + " with ID " + this.role.getId() + " failed... Reason: " + response.toString());
        }
        new EntityBuilder((JDAImpl)this.role.getJDA()).createRole(response.getObject(), this.role.getGuild().getId());
    }

    private void checkPermission(Permission perm) {
        if (!PermissionUtil.checkPermission((User)this.role.getJDA().getSelfInfo(), perm, this.role.getGuild())) {
            throw new PermissionException(perm);
        }
    }

    private void checkPosition() {
        if (!PermissionUtil.canInteract(this.role.getJDA().getSelfInfo(), this.role)) {
            throw new PermissionException("Can't modify role >= highest self-role");
        }
    }
}

