/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.managers;

import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.exceptions.PermissionException;
import org.json.JSONObject;

public class PermissionOverrideManager {
    private final PermissionOverride override;
    private int allow;
    private int deny;

    public PermissionOverrideManager(PermissionOverride override) {
        this.override = override;
        this.allow = override.getAllowedRaw();
        this.deny = override.getDeniedRaw();
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
    }

    public PermissionOverrideManager overwrite(PermissionOverride overwrite) {
        throw new UnsupportedOperationException("Method temporarily disabled");
    }

    public PermissionOverrideManager grant(Permission ... perms) {
        for (Permission perm : perms) {
            this.checkPermission(perm);
        }
        for (Permission perm : perms) {
            this.allow |= 1 << perm.getOffset();
        }
        this.deny &= ~this.allow;
        return this;
    }

    public PermissionOverrideManager deny(Permission ... perms) {
        for (Permission perm : perms) {
            this.checkPermission(perm);
        }
        for (Permission perm : perms) {
            this.deny |= 1 << perm.getOffset();
        }
        this.allow &= ~this.deny;
        return this;
    }

    public PermissionOverrideManager reset(Permission ... perms) {
        for (Permission perm : perms) {
            this.checkPermission(perm);
        }
        for (Permission perm : perms) {
            this.allow &= ~(1 << perm.getOffset());
            this.deny &= ~(1 << perm.getOffset());
        }
        return this;
    }

    public void delete() {
        String targetId = this.override.isRoleOverride() ? this.override.getRole().getId() : this.override.getUser().getId();
        ((JDAImpl)this.override.getJDA()).getRequester().delete("https://discordapp.com/api/channels/" + this.override.getChannel().getId() + "/permissions/" + targetId);
    }

    public void reset() {
        this.allow = this.override.getAllowedRaw();
        this.deny = this.override.getDeniedRaw();
    }

    public void update() {
        if (this.allow == this.override.getAllowedRaw() && this.deny == this.override.getDeniedRaw()) {
            return;
        }
        String targetId = this.override.isRoleOverride() ? this.override.getRole().getId() : this.override.getUser().getId();
        ((JDAImpl)this.override.getJDA()).getRequester().put("https://discordapp.com/api/channels/" + this.override.getChannel().getId() + "/permissions/" + targetId, new JSONObject().put("allow", this.allow).put("deny", this.deny).put("id", targetId).put("type", this.override.isRoleOverride() ? "role" : "member"));
    }

    private void checkPermission(Permission permission) {
        if (!this.override.getChannel().checkPermission(this.override.getJDA().getSelfInfo(), permission)) {
            throw new PermissionException(permission);
        }
    }
}

