/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.hooks;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.Event;
import net.dv8tion.jda.hooks.IEventManager;
import net.dv8tion.jda.hooks.SubscribeEvent;

public class AnnotatedEventManager
implements IEventManager {
    private final Set<Object> listeners = new HashSet<Object>();
    private final Map<Class<? extends Event>, Map<Object, Method>> methods = new HashMap<Class<? extends Event>, Map<Object, Method>>();

    @Override
    public void register(Object listener) {
        if (this.listeners.add(listener)) {
            this.updateMethods();
        }
    }

    @Override
    public void unregister(Object listener) {
        if (this.listeners.remove(listener)) {
            this.updateMethods();
        }
    }

    @Override
    public List<Object> getRegisteredListeners() {
        return Collections.unmodifiableList(new LinkedList<Object>(this.listeners));
    }

    @Override
    public void handle(Event event) {
        Class<?> eventClass = event.getClass();
        do {
            Map<Object, Method> listeners;
            if ((listeners = this.methods.get(eventClass)) == null) continue;
            listeners.entrySet().forEach(e -> {
                try {
                    ((Method)e.getValue()).setAccessible(true);
                    ((Method)e.getValue()).invoke(e.getKey(), event);
                }
                catch (IllegalAccessException | InvocationTargetException e1) {
                    JDAImpl.LOG.log(e1);
                }
                catch (Throwable throwable) {
                    JDAImpl.LOG.fatal("One of the EventListeners had an uncaught exception");
                    JDAImpl.LOG.log(throwable);
                }
            });
        } while ((eventClass = eventClass == Event.class ? null : eventClass.getSuperclass()) != null);
    }

    private void updateMethods() {
        this.methods.clear();
        for (Object listener : this.listeners) {
            Method[] allMethods;
            Class<?> c = listener.getClass();
            for (Method m : allMethods = c.getDeclaredMethods()) {
                Class<?>[] pType;
                if (!m.isAnnotationPresent(SubscribeEvent.class) || (pType = m.getParameterTypes()).length != 1 || !Event.class.isAssignableFrom(pType[0])) continue;
                Class<?> eventClass = pType[0];
                if (!this.methods.containsKey(eventClass)) {
                    this.methods.put(eventClass, new HashMap());
                }
                this.methods.get(eventClass).put(listener, m);
            }
        }
    }
}

