/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.OnlineStatus;
import net.dv8tion.jda.entities.Game;
import net.dv8tion.jda.entities.impl.GameImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.events.user.GenericUserEvent;
import net.dv8tion.jda.events.user.UserAvatarUpdateEvent;
import net.dv8tion.jda.events.user.UserGameUpdateEvent;
import net.dv8tion.jda.events.user.UserNameUpdateEvent;
import net.dv8tion.jda.events.user.UserOnlineStatusUpdateEvent;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class PresenceUpdateHandler
extends SocketHandler {
    public PresenceUpdateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (!content.has("guild_id")) {
            return null;
        }
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        JSONObject jsonUser = content.getJSONObject("user");
        String id = jsonUser.getString("id");
        UserImpl user = (UserImpl)this.api.getUserMap().get(id);
        if (user == null) {
            return null;
        }
        if (jsonUser.has("username")) {
            String avatarId;
            String username = jsonUser.getString("username");
            String discriminator = jsonUser.get("discriminator").toString();
            String string = avatarId = jsonUser.isNull("avatar") ? null : jsonUser.getString("avatar");
            if (!user.getUsername().equals(username)) {
                String oldUsername = user.getUsername();
                user.setUserName(username);
                user.setDiscriminator(discriminator);
                this.api.getEventManager().handle(new UserNameUpdateEvent(this.api, this.responseNumber, user, oldUsername));
            }
            String oldAvatar = user.getAvatarId();
            if (!(avatarId == null && oldAvatar == null || StringUtils.equals(avatarId, oldAvatar))) {
                String oldAvatarId = user.getAvatarId();
                user.setAvatarId(avatarId);
                this.api.getEventManager().handle(new UserAvatarUpdateEvent(this.api, this.responseNumber, user, oldAvatarId));
            }
        }
        String gameName = null;
        String gameUrl = null;
        Game.GameType type = null;
        if (!content.isNull("game") && !content.getJSONObject("game").isNull("name")) {
            gameName = content.getJSONObject("game").get("name").toString();
            gameUrl = content.getJSONObject("game").isNull("url") ? null : content.getJSONObject("game").get("url").toString();
            try {
                type = content.getJSONObject("game").isNull("type") ? Game.GameType.DEFAULT : Game.GameType.fromKey(Integer.parseInt(content.getJSONObject("game").get("type").toString()));
            }
            catch (NumberFormatException ex) {
                type = Game.GameType.DEFAULT;
            }
        }
        GameImpl nextGame = gameName == null ? null : new GameImpl(gameName, gameUrl, type);
        OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
        if (!user.getOnlineStatus().equals((Object)status)) {
            OnlineStatus oldStatus = user.getOnlineStatus();
            user.setOnlineStatus(status);
            this.api.getEventManager().handle(new UserOnlineStatusUpdateEvent(this.api, this.responseNumber, user, oldStatus));
        }
        if (user.getCurrentGame() == null ? nextGame != null : !user.getCurrentGame().equals(nextGame)) {
            Game oldGame = user.getCurrentGame();
            user.setCurrentGame(nextGame);
            this.api.getEventManager().handle(new UserGameUpdateEvent(this.api, this.responseNumber, user, oldGame));
        }
        this.api.getEventManager().handle(new GenericUserEvent(this.api, this.responseNumber, user));
        return null;
    }
}

