/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.Message;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.message.MessageUpdateEvent;
import net.dv8tion.jda.events.message.guild.GuildMessageUpdateEvent;
import net.dv8tion.jda.events.message.priv.PrivateMessageUpdateEvent;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class MessageUpdateHandler
extends SocketHandler {
    public MessageUpdateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        Message message = new EntityBuilder(this.api).createMessage(content);
        if (!message.isPrivate()) {
            TextChannel channel = this.api.getChannelMap().get(message.getChannelId());
            if (GuildLock.get(this.api).isLocked(channel.getGuild().getId())) {
                return channel.getGuild().getId();
            }
            this.api.getEventManager().handle(new GuildMessageUpdateEvent(this.api, this.responseNumber, message, channel));
        } else {
            this.api.getEventManager().handle(new PrivateMessageUpdateEvent(this.api, this.responseNumber, message, this.api.getPmChannelMap().get(message.getChannelId())));
        }
        this.api.getEventManager().handle(new MessageUpdateEvent(this.api, this.responseNumber, message));
        return null;
    }
}

