/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.JDA;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.TextChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.message.MessageDeleteEvent;
import net.dv8tion.jda.events.message.guild.GuildMessageDeleteEvent;
import net.dv8tion.jda.events.message.priv.PrivateMessageDeleteEvent;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class MessageDeleteHandler
extends SocketHandler {
    public MessageDeleteHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String messageId = content.getString("id");
        String channelId = content.getString("channel_id");
        TextChannel channel = this.api.getChannelMap().get(channelId);
        if (channel != null) {
            if (GuildLock.get(this.api).isLocked(channel.getGuild().getId())) {
                return channel.getGuild().getId();
            }
            this.api.getEventManager().handle(new GuildMessageDeleteEvent((JDA)this.api, this.responseNumber, messageId, channel));
        } else {
            PrivateChannel privChannel = this.api.getPmChannelMap().get(channelId);
            if (privChannel == null) {
                throw new IllegalArgumentException("Message deleted in unknown channel! (unknown channel id). JSON: " + content);
            }
            this.api.getEventManager().handle(new PrivateMessageDeleteEvent((JDA)this.api, this.responseNumber, messageId, privChannel));
        }
        this.api.getEventManager().handle(new MessageDeleteEvent(this.api, this.responseNumber, messageId, channelId, channel == null));
        return null;
    }
}

