/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.events.guild.member.GuildMemberBanEvent;
import net.dv8tion.jda.events.guild.member.GuildMemberUnbanEvent;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class GuildMemberBanHandler
extends SocketHandler {
    private final boolean banned;

    public GuildMemberBanHandler(JDAImpl api, int responseNumber, boolean banned) {
        super(api, responseNumber);
        this.banned = banned;
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        JSONObject userJson = content.getJSONObject("user");
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
        User user = this.api.getUserMap().get(userJson.getString("id"));
        if (user == null) {
            user = new UserImpl(userJson.getString("id"), (JDAImpl)guild.getJDA()).setUserName(userJson.getString("username")).setDiscriminator(userJson.get("discriminator").toString()).setAvatarId(userJson.isNull("avatar") ? null : userJson.getString("avatar"));
        }
        if (this.banned) {
            this.api.getEventManager().handle(new GuildMemberBanEvent(this.api, this.responseNumber, guild, user));
        } else {
            this.api.getEventManager().handle(new GuildMemberUnbanEvent(this.api, this.responseNumber, guild, user));
        }
        return null;
    }
}

