/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.HashSet;
import java.util.List;
import net.dv8tion.jda.entities.Emote;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.impl.EmoteImpl;
import net.dv8tion.jda.entities.impl.GuildImpl;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.entities.impl.TextChannelImpl;
import net.dv8tion.jda.entities.impl.UserImpl;
import net.dv8tion.jda.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.events.guild.GuildUnavailableEvent;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.managers.AudioManager;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class GuildLeaveHandler
extends SocketHandler {
    public GuildLeaveHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("id"))) {
            return content.getString("id");
        }
        Guild guild = this.api.getGuildMap().get(content.getString("id"));
        AudioManager manager = this.api.getAudioManagersMap().get(guild);
        if (manager != null) {
            manager.closeAudioConnection();
        }
        if (content.has("unavailable") && content.getBoolean("unavailable")) {
            ((GuildImpl)guild).setAvailable(false);
            this.api.getEventManager().handle(new GuildUnavailableEvent(this.api, this.responseNumber, guild));
            return null;
        }
        if (manager != null) {
            this.api.getAudioManagersMap().remove(guild);
        }
        List<User> users = guild.getUsers();
        HashSet<User> usersInOtherGuilds = new HashSet<User>();
        for (Guild g : this.api.getGuilds()) {
            if (g == guild) continue;
            usersInOtherGuilds.addAll(g.getUsers());
        }
        for (User user : users) {
            if (usersInOtherGuilds.contains(user)) continue;
            if (((UserImpl)user).hasPrivateChannel()) {
                this.api.getOffline_pms().put(user.getId(), user.getPrivateChannel().getId());
            }
            this.api.getUserMap().remove(user.getId());
        }
        List<Emote> emotes = guild.getEmotes();
        for (Emote e : emotes) {
            ((EmoteImpl)e).removeGuild(guild);
            if (!e.getGuilds().isEmpty()) continue;
            this.api.getEmoteMap().remove(e.getId());
        }
        this.api.getGuildMap().remove(guild.getId());
        guild.getTextChannels().forEach(chan -> this.api.getChannelMap().remove(chan.getId()));
        guild.getVoiceChannels().forEach(chan -> this.api.getVoiceChannelMap().remove(chan.getId()));
        TextChannelImpl.AsyncMessageSender.stop(this.api, guild.getId());
        this.api.getEventManager().handle(new GuildLeaveEvent(this.api, this.responseNumber, guild));
        return null;
    }
}

