/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.utils.SimpleLog;

public class EventCache {
    public static final SimpleLog LOG = SimpleLog.getLog("EventCache");
    private static HashMap<JDA, EventCache> caches = new HashMap();
    private HashMap<Type, HashMap<String, List<Runnable>>> eventCache = new HashMap();

    public static EventCache get(JDA jda) {
        EventCache cache = caches.get(jda);
        if (cache == null) {
            cache = new EventCache();
            caches.put(jda, cache);
        }
        return cache;
    }

    protected void cache(Type type, String triggerId, Runnable handler) {
        List<Runnable> items;
        HashMap<String, List<Runnable>> triggerCache = this.eventCache.get((Object)type);
        if (triggerCache == null) {
            triggerCache = new HashMap();
            this.eventCache.put(type, triggerCache);
        }
        if ((items = triggerCache.get(triggerId)) == null) {
            items = new LinkedList<Runnable>();
            triggerCache.put(triggerId, items);
        }
        items.add(handler);
    }

    protected void playbackCache(Type type, String triggerId) {
        List<Runnable> items;
        try {
            items = this.eventCache.get((Object)type).get(triggerId);
        }
        catch (NullPointerException e) {
            return;
        }
        if (items != null && !items.isEmpty()) {
            LOG.debug("Replaying " + items.size() + " events from the EventCache for a " + (Object)((Object)type) + " with id: " + triggerId);
            LinkedList<Runnable> itemsCopy = new LinkedList<Runnable>(items);
            items.clear();
            for (Runnable item : itemsCopy) {
                item.run();
            }
        }
    }

    public int size() {
        int count = 0;
        for (HashMap<String, List<Runnable>> typeMap : this.eventCache.values()) {
            for (List<Runnable> eventList : typeMap.values()) {
                count += eventList.size();
            }
        }
        return count;
    }

    public void clear() {
        this.eventCache.clear();
    }

    static enum Type {
        USER,
        GUILD,
        CHANNEL,
        ROLE;

    }
}

