/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.handle;

import net.dv8tion.jda.entities.ChannelType;
import net.dv8tion.jda.entities.PrivateChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.channel.priv.PrivateChannelCreateEvent;
import net.dv8tion.jda.events.channel.text.TextChannelCreateEvent;
import net.dv8tion.jda.events.channel.voice.VoiceChannelCreateEvent;
import net.dv8tion.jda.handle.EntityBuilder;
import net.dv8tion.jda.handle.EventCache;
import net.dv8tion.jda.handle.SocketHandler;
import net.dv8tion.jda.requests.GuildLock;
import org.json.JSONObject;

public class ChannelCreateHandler
extends SocketHandler {
    public ChannelCreateHandler(JDAImpl api, int responseNumber) {
        super(api, responseNumber);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if ((type == ChannelType.TEXT || type == ChannelType.VOICE) && GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        switch (type) {
            case TEXT: {
                this.api.getEventManager().handle(new TextChannelCreateEvent(this.api, this.responseNumber, new EntityBuilder(this.api).createTextChannel(content, content.getString("guild_id"))));
                break;
            }
            case VOICE: {
                this.api.getEventManager().handle(new VoiceChannelCreateEvent(this.api, this.responseNumber, new EntityBuilder(this.api).createVoiceChannel(content, content.getString("guild_id"))));
                break;
            }
            case PRIVATE: {
                PrivateChannel pc = new EntityBuilder(this.api).createPrivateChannel(content);
                if (pc == null) {
                    JDAImpl.LOG.warn("Discord API sent us a Private CREATE_CHANNEL for a user we can't see, ignoring event.");
                    break;
                }
                this.api.getEventManager().handle(new PrivateChannelCreateEvent(this.api, this.responseNumber, pc.getUser()));
                break;
            }
            case GROUP: {
                JDAImpl.LOG.debug("Received GROUP channel create. Ignoring because JDA doesn't support groups. (Use JDA-Client)");
                break;
            }
            default: {
                throw new IllegalArgumentException("Discord provided an CREATE_CHANNEL event with an unknown channel type! JSON: " + content);
            }
        }
        EventCache.get(this.api).playbackCache(EventCache.Type.CHANNEL, content.getString("id"));
        return null;
    }
}

