/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import java.time.OffsetDateTime;
import java.util.List;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.managers.RoleManager;
import net.dv8tion.jda.utils.MiscUtil;

public class RoleImpl
implements Role {
    private final String id;
    private final Guild guild;
    private String name;
    private int color;
    private int position;
    private int permissions;
    private boolean managed;
    private boolean grouped;
    private boolean mentionable;
    private RoleManager manager = null;

    public RoleImpl(String id, Guild guild) {
        this.id = id;
        this.guild = guild;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getPermissionsRaw() {
        return this.permissions;
    }

    @Override
    public List<Permission> getPermissions() {
        return Permission.getPermissions(this.permissions);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getPosition() {
        if (this == this.guild.getPublicRole()) {
            return -1;
        }
        int i = this.guild.getRoles().size() - 2;
        for (Role r : this.guild.getRoles()) {
            if (r == this) {
                return i;
            }
            --i;
        }
        throw new RuntimeException("Somehow when determining position we never found the role in the Guild's roles? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.position;
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return (1 << perm.getOffset() & this.permissions) > 0 || (1 << Permission.ADMINISTRATOR.getOffset() & this.permissions) > 0;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isGrouped() {
        return this.grouped;
    }

    @Override
    public boolean isMentionable() {
        return this.mentionable;
    }

    @Override
    public String getAsMention() {
        return "<@&" + this.getId() + '>';
    }

    @Override
    public synchronized RoleManager getManager() {
        if (this.manager == null) {
            this.manager = new RoleManager(this);
        }
        return this.manager;
    }

    public RoleImpl setName(String name) {
        this.name = name;
        return this;
    }

    public RoleImpl setColor(int color) {
        this.color = color;
        return this;
    }

    public RoleImpl setPosition(int position) {
        this.position = position;
        return this;
    }

    public RoleImpl setPermissions(int permissions) {
        this.permissions = permissions;
        return this;
    }

    public RoleImpl setManaged(boolean managed) {
        this.managed = managed;
        return this;
    }

    public RoleImpl setGrouped(boolean grouped) {
        this.grouped = grouped;
        return this;
    }

    public RoleImpl setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Role)) {
            return false;
        }
        Role oRole = (Role)o;
        return this == oRole || this.getId().equals(oRole.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "R:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public int compareTo(Role r) {
        if (this == r) {
            return 0;
        }
        if (this.getGuild() != r.getGuild()) {
            throw new IllegalArgumentException("Cannot compare roles that aren't from the same guild!");
        }
        if (this.getPositionRaw() != r.getPositionRaw()) {
            return this.getPositionRaw() - r.getPositionRaw();
        }
        OffsetDateTime thisTime = MiscUtil.getCreationTime(this);
        OffsetDateTime rTime = MiscUtil.getCreationTime(r);
        return rTime.compareTo(thisTime);
    }
}

