/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.entities.impl;

import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.Permission;
import net.dv8tion.jda.entities.Channel;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.PermissionOverride;
import net.dv8tion.jda.entities.Role;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.managers.PermissionOverrideManager;

public class PermissionOverrideImpl
implements PermissionOverride {
    private final User user;
    private final Role role;
    private final Channel channel;
    private int allow;
    private int deny;
    private PermissionOverrideManager manager = null;

    public PermissionOverrideImpl(Channel channel, User user, Role role) {
        this.channel = channel;
        this.user = user;
        this.role = role;
    }

    @Override
    public int getAllowedRaw() {
        return this.allow;
    }

    @Override
    public int getInheritRaw() {
        return ~(this.allow | this.deny);
    }

    @Override
    public int getDeniedRaw() {
        return this.deny;
    }

    @Override
    public List<Permission> getAllowed() {
        return Collections.unmodifiableList(Permission.getPermissions(this.allow));
    }

    @Override
    public List<Permission> getInherit() {
        return Collections.unmodifiableList(Permission.getPermissions(this.getInheritRaw()));
    }

    @Override
    public List<Permission> getDenied() {
        return Collections.unmodifiableList(Permission.getPermissions(this.deny));
    }

    @Override
    public JDA getJDA() {
        return this.channel.getJDA();
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Guild getGuild() {
        return this.channel.getGuild();
    }

    @Override
    public boolean isUserOverride() {
        return this.getUser() != null;
    }

    @Override
    public boolean isRoleOverride() {
        return this.getRole() != null;
    }

    public PermissionOverrideImpl setAllow(int allow) {
        this.allow = allow;
        return this;
    }

    public PermissionOverrideImpl setDeny(int deny) {
        this.deny = deny;
        return this;
    }

    @Override
    public synchronized PermissionOverrideManager getManager() {
        if (this.manager == null) {
            this.manager = new PermissionOverrideManager(this);
        }
        return this.manager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PermissionOverride)) {
            return false;
        }
        PermissionOverride oPerm = (PermissionOverride)o;
        return this == oPerm || (this.user == null ? oPerm.getUser() == null : this.user.equals(oPerm.getUser())) && this.channel.equals(oPerm.getChannel()) && (this.role == null ? oPerm.getRole() == null : this.role.equals(oPerm.getRole()));
    }

    public int hashCode() {
        return this.user == null ? this.channel.getId().hashCode() | this.role.getId().hashCode() : this.channel.getId().hashCode() | this.user.getId().hashCode();
    }

    public String toString() {
        return "PermOverwrite";
    }
}

