/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.audio.player;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.audio.player.Player;
import net.dv8tion.jda.requests.Requester;
import net.dv8tion.jda.utils.SimpleLog;
import org.apache.http.HttpHost;

public class URLPlayer
extends Player {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    protected final JDA api;
    protected String userAgent = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.80 Safari/537.36 " + Requester.USER_AGENT;
    protected URL urlOfResource = null;
    protected InputStream resourceStream = null;
    protected BufferedInputStream bufferedResourceStream = null;
    protected boolean started = false;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean stopped = true;

    public URLPlayer(JDA api) {
        this.api = api;
    }

    public URLPlayer(JDA api, URL urlOfResource) throws IOException, UnsupportedAudioFileException {
        this.api = api;
        this.setAudioUrl(urlOfResource);
    }

    public URLPlayer(JDA api, URL urlOfResource, int bufferSize) throws IOException, UnsupportedAudioFileException {
        this.api = api;
        this.setAudioUrl(urlOfResource, bufferSize);
    }

    public void setAudioUrl(URL urlOfResource) throws IOException, UnsupportedAudioFileException {
        this.setAudioUrl(urlOfResource, 8192);
    }

    public void setAudioUrl(URL urlOfResource, int bufferSize) throws IOException, UnsupportedAudioFileException {
        if (urlOfResource == null) {
            throw new IllegalArgumentException("A null URL was provided to the Player! Cannot find resource to play from a null URL!");
        }
        this.urlOfResource = urlOfResource;
        URLConnection conn = null;
        HttpHost jdaProxy = this.api.getGlobalProxy();
        if (jdaProxy != null) {
            InetSocketAddress proxyAddress = new InetSocketAddress(jdaProxy.getHostName(), jdaProxy.getPort());
            Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddress);
            conn = urlOfResource.openConnection(proxy);
        } else {
            conn = urlOfResource.openConnection();
        }
        if (conn == null) {
            throw new IllegalArgumentException("The provided URL resulted in a null URLConnection! Does the resource exist?");
        }
        conn.setRequestProperty("user-agent", this.userAgent);
        this.resourceStream = conn.getInputStream();
        this.bufferedResourceStream = new BufferedInputStream(this.resourceStream, bufferSize);
        this.setAudioSource(AudioSystem.getAudioInputStream(this.bufferedResourceStream));
    }

    @Override
    public void play() {
        if (this.started && this.stopped) {
            throw new IllegalStateException("Cannot start a player after it has been stopped.\nPlease use the restart method or load a new file.");
        }
        this.started = true;
        this.playing = true;
        this.paused = false;
        this.stopped = false;
    }

    @Override
    public void pause() {
        this.playing = false;
        this.paused = true;
    }

    @Override
    public void stop() {
        this.playing = false;
        this.paused = false;
        this.stopped = true;
        try {
            this.bufferedResourceStream.close();
            this.resourceStream.close();
        }
        catch (IOException e) {
            SimpleLog.getLog("JDAPlayer").fatal("Attempted to close the URLPlayer resource stream during stop() cleanup, but hit an IOException");
            SimpleLog.getLog("JDAPlayer").log(e);
        }
    }

    @Override
    public void restart() {
        URL oldUrl = this.urlOfResource;
        try {
            this.bufferedResourceStream.close();
            this.resourceStream.close();
            this.reset();
            this.setAudioUrl(oldUrl);
            this.play();
        }
        catch (IOException e) {
            SimpleLog.getLog("JDAPlayer").fatal("Attempted to restart the URLStream playback, but something went wrong!");
            SimpleLog.getLog("JDAPlayer").log(e);
        }
        catch (UnsupportedAudioFileException e) {
            SimpleLog.getLog("JDAPlayer").log(e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    protected void reset() {
        this.started = false;
        this.playing = false;
        this.paused = false;
        this.stopped = true;
        this.urlOfResource = null;
        this.resourceStream = null;
    }
}

