/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.audio.player;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.dv8tion.jda.audio.player.Player;
import net.dv8tion.jda.utils.SimpleLog;

public class FilePlayer
extends Player {
    private File audioFile = null;
    private boolean started = false;
    private boolean playing = false;
    private boolean paused = false;
    private boolean stopped = true;

    public FilePlayer() {
    }

    public FilePlayer(File file) throws IOException, UnsupportedAudioFileException {
        this.setAudioFile(file);
    }

    public void setAudioFile(File file) throws IOException, UnsupportedAudioFileException {
        if (file == null) {
            throw new IllegalArgumentException("A null File was provided to the FilePlayer! Cannot play a null file!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("A non-existent file was provided to the FilePlayer! Cannot play a file that doesn't exist!");
        }
        this.reset();
        this.audioFile = file;
        this.setAudioSource(AudioSystem.getAudioInputStream(file));
    }

    @Override
    public void play() {
        if (this.started && this.stopped) {
            throw new IllegalStateException("Cannot start a player after it has been stopped.\nPlease use the restart method or load a new file.");
        }
        this.started = true;
        this.playing = true;
        this.paused = false;
        this.stopped = false;
    }

    @Override
    public void pause() {
        this.playing = false;
        this.paused = true;
    }

    @Override
    public void stop() {
        this.playing = false;
        this.paused = false;
        this.stopped = true;
    }

    @Override
    public void restart() {
        try {
            File oldFile = this.audioFile;
            this.reset();
            this.setAudioFile(oldFile);
            this.play();
        }
        catch (IOException e) {
            if (!this.audioFile.exists()) {
                SimpleLog.getLog("JDAPlayer").fatal("Attempted to restart the FilePlayer playback, but the provided file no longer exists!");
            }
            SimpleLog.getLog("JDAPlayer").log(e);
        }
        catch (UnsupportedAudioFileException e) {
            SimpleLog.getLog("JDAPlayer").log(e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    protected void reset() {
        this.audioFile = null;
        this.started = false;
        this.playing = false;
        this.paused = false;
        this.stopped = true;
    }
}

