/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.audio;

import com.sun.jna.ptr.PointerByReference;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.JDA;
import net.dv8tion.jda.audio.AudioPacket;
import net.dv8tion.jda.audio.AudioReceiveHandler;
import net.dv8tion.jda.audio.AudioSendHandler;
import net.dv8tion.jda.audio.AudioWebSocket;
import net.dv8tion.jda.audio.CombinedAudio;
import net.dv8tion.jda.audio.Decoder;
import net.dv8tion.jda.audio.UserAudio;
import net.dv8tion.jda.entities.Guild;
import net.dv8tion.jda.entities.User;
import net.dv8tion.jda.entities.VoiceChannel;
import net.dv8tion.jda.entities.impl.JDAImpl;
import net.dv8tion.jda.events.audio.AudioConnectEvent;
import net.dv8tion.jda.events.audio.AudioTimeoutEvent;
import net.dv8tion.jda.utils.SimpleLog;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONObject;
import tomp2p.opuswrapper.Opus;

public class AudioConnection {
    public static final SimpleLog LOG = SimpleLog.getLog("JDAAudioConn");
    public static final int OPUS_SAMPLE_RATE = 48000;
    public static final int OPUS_FRAME_SIZE = 960;
    public static final int OPUS_FRAME_TIME_AMOUNT = 20;
    public static final int OPUS_CHANNEL_COUNT = 2;
    private final AudioWebSocket webSocket;
    private DatagramSocket udpSocket;
    private VoiceChannel channel;
    private volatile AudioSendHandler sendHandler = null;
    private volatile AudioReceiveHandler receiveHandler = null;
    private PointerByReference opusEncoder;
    private volatile HashMap<Integer, String> ssrcMap = new HashMap();
    private volatile HashMap<Integer, Decoder> opusDecoders = new HashMap();
    private volatile HashMap<User, Queue<Pair<Long, short[]>>> combinedQueue = new HashMap();
    private ScheduledExecutorService combinedAudioExecutor;
    private Thread sendThread;
    private Thread receiveThread;
    private long queueTimeout;
    private volatile boolean couldReceive = false;
    private volatile boolean speaking = false;
    private volatile int silenceCounter = 0;
    private final byte[] silenceBytes = new byte[]{-8, -1, -2};

    public AudioConnection(AudioWebSocket webSocket, VoiceChannel channel) {
        this.channel = channel;
        this.webSocket = webSocket;
        this.webSocket.audioConnection = this;
        IntBuffer error = IntBuffer.allocate(4);
        this.opusEncoder = Opus.INSTANCE.opus_encoder_create(48000, 2, 2049, error);
    }

    public void ready(final long timeout) {
        Thread readyThread = new Thread("AudioConnection Ready Guild: " + this.channel.getGuild().getId()){

            @Override
            public void run() {
                JDAImpl api = (JDAImpl)AudioConnection.this.getJDA();
                long started = System.currentTimeMillis();
                boolean connectionTimeout = false;
                while (!AudioConnection.this.webSocket.isReady() && !connectionTimeout) {
                    if (timeout > 0L && System.currentTimeMillis() - started > timeout) {
                        connectionTimeout = true;
                        break;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        LOG.log(e);
                    }
                }
                if (!connectionTimeout) {
                    AudioConnection.this.udpSocket = AudioConnection.this.webSocket.getUdpSocket();
                    AudioConnection.this.setupSendThread();
                    AudioConnection.this.setupReceiveThread();
                    api.getEventManager().handle(new AudioConnectEvent((JDA)api, AudioConnection.this.channel));
                } else {
                    AudioConnection.this.webSocket.close(false, -41);
                    api.getEventManager().handle(new AudioTimeoutEvent(api, AudioConnection.this.channel, timeout));
                }
            }
        };
        readyThread.setDaemon(true);
        readyThread.start();
    }

    public void setSendingHandler(AudioSendHandler handler) {
        this.setupSendThread();
        this.sendHandler = handler;
    }

    public void setReceivingHandler(AudioReceiveHandler handler) {
        this.setupReceiveThread();
        this.receiveHandler = handler;
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public VoiceChannel getChannel() {
        return this.channel;
    }

    public void setChannel(VoiceChannel channel) {
        this.channel = channel;
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public Guild getGuild() {
        return this.channel.getGuild();
    }

    public void updateUserSSRC(int ssrc, String userId, boolean talking) {
        User user;
        String previousId = this.ssrcMap.get(ssrc);
        if (previousId != null) {
            if (!previousId.equals(userId)) {
                LOG.fatal("Yeah.. So.. JDA received a UserSSRC update for an ssrc that already had a User set. Inform DV8FromTheWorld.\nChannelId: " + this.channel.getId() + " SSRC: " + ssrc + " oldId: " + previousId + " newId: " + userId);
            }
        } else {
            this.ssrcMap.put(ssrc, userId);
            this.opusDecoders.put(ssrc, new Decoder(ssrc));
        }
        if (this.receiveHandler != null && (user = this.getJDA().getUserById(userId)) != null) {
            this.receiveHandler.handleUserTalking(user, talking);
        }
    }

    public void close(boolean regionChange) {
        if (this.sendThread != null) {
            this.sendThread.interrupt();
        }
        if (this.receiveThread != null) {
            this.receiveThread.interrupt();
        }
        this.webSocket.close(regionChange, -1);
    }

    private void setupSendThread() {
        if (this.sendThread == null && this.udpSocket != null && this.sendHandler != null) {
            this.sendThread = new Thread("AudioConnection SendThread Guild: " + this.channel.getGuild().getId()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    char seq = '\u0000';
                    int timestamp = 0;
                    long lastFrameSent = System.currentTimeMillis();
                    boolean sentSilenceOnConnect = false;
                    while (!AudioConnection.this.udpSocket.isClosed() && !this.isInterrupted()) {
                        try {
                            if (sentSilenceOnConnect && AudioConnection.this.sendHandler != null && AudioConnection.this.sendHandler.canProvide()) {
                                AudioConnection.this.silenceCounter = -1;
                                byte[] rawAudio = AudioConnection.this.sendHandler.provide20MsAudio();
                                if (rawAudio == null || rawAudio.length == 0) {
                                    if (!AudioConnection.this.speaking || System.currentTimeMillis() - lastFrameSent <= 20L) continue;
                                    AudioConnection.this.setSpeaking(false);
                                    continue;
                                }
                                if (!AudioConnection.this.sendHandler.isOpus()) {
                                    rawAudio = AudioConnection.this.encodeToOpus(rawAudio);
                                }
                                AudioPacket packet = new AudioPacket(seq, timestamp, AudioConnection.this.webSocket.getSSRC(), rawAudio);
                                if (!AudioConnection.this.speaking) {
                                    AudioConnection.this.setSpeaking(true);
                                }
                                AudioConnection.this.udpSocket.send(packet.asEncryptedUdpPacket(AudioConnection.this.webSocket.getAddress(), AudioConnection.this.webSocket.getSecretKey()));
                                if (seq + '\u0001' > 65535) {
                                    seq = '\u0000';
                                    continue;
                                }
                                seq = (char)(seq + '\u0001');
                                continue;
                            }
                            if (AudioConnection.this.silenceCounter > -1) {
                                AudioPacket packet = new AudioPacket(seq, timestamp, AudioConnection.this.webSocket.getSSRC(), AudioConnection.this.silenceBytes);
                                AudioConnection.this.udpSocket.send(packet.asEncryptedUdpPacket(AudioConnection.this.webSocket.getAddress(), AudioConnection.this.webSocket.getSecretKey()));
                                seq = seq + '\u0001' > 65535 ? (char)'\u0000' : (char)(seq + '\u0001');
                                if (++AudioConnection.this.silenceCounter <= 10) continue;
                                AudioConnection.this.silenceCounter = -1;
                                sentSilenceOnConnect = true;
                                continue;
                            }
                            if (!AudioConnection.this.speaking || System.currentTimeMillis() - lastFrameSent <= 20L) continue;
                            AudioConnection.this.setSpeaking(false);
                        }
                        catch (NoRouteToHostException e) {
                            LOG.warn("Closing AudioConnection due to inability to send audio packets.");
                            LOG.warn("Cannot send audio packet because JDA cannot navigate the route to Discord.\nAre you sure you have internet connection? It is likely that you've lost connection.");
                            AudioConnection.this.webSocket.close(true, -1);
                        }
                        catch (SocketException sleepTime) {
                        }
                        catch (Exception e) {
                            LOG.log(e);
                        }
                        finally {
                            timestamp += 960;
                            long sleepTime = 20L - (System.currentTimeMillis() - lastFrameSent);
                            if (sleepTime > 0L) {
                                try {
                                    Thread.sleep(sleepTime);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if (System.currentTimeMillis() < lastFrameSent + 60L) {
                                lastFrameSent += 20L;
                                continue;
                            }
                            lastFrameSent = System.currentTimeMillis();
                        }
                    }
                }
            };
            this.sendThread.setPriority(7);
            this.sendThread.setDaemon(true);
            this.sendThread.start();
        }
    }

    private void setupReceiveThread() {
        if (this.receiveHandler != null && this.udpSocket != null) {
            if (this.receiveThread == null) {
                this.receiveThread = new Thread("AudioConnection ReceiveThread Guild: " + this.channel.getGuild().getId()){

                    @Override
                    public void run() {
                        try {
                            AudioConnection.this.udpSocket.setSoTimeout(100);
                        }
                        catch (SocketException e) {
                            LOG.log(e);
                        }
                        while (!AudioConnection.this.udpSocket.isClosed() && !this.isInterrupted()) {
                            DatagramPacket receivedPacket = new DatagramPacket(new byte[1920], 1920);
                            try {
                                AudioConnection.this.udpSocket.receive(receivedPacket);
                                if (AudioConnection.this.receiveHandler != null && (AudioConnection.this.receiveHandler.canReceiveUser() || AudioConnection.this.receiveHandler.canReceiveCombined()) && AudioConnection.this.webSocket.getSecretKey() != null) {
                                    if (!AudioConnection.this.couldReceive) {
                                        AudioConnection.this.couldReceive = true;
                                        AudioConnection.this.sendSilentPackets();
                                    }
                                    AudioPacket decryptedPacket = AudioPacket.decryptAudioPacket(receivedPacket, AudioConnection.this.webSocket.getSecretKey());
                                    String userId = (String)AudioConnection.this.ssrcMap.get(decryptedPacket.getSSRC());
                                    Decoder decoder = (Decoder)AudioConnection.this.opusDecoders.get(decryptedPacket.getSSRC());
                                    if (userId == null) {
                                        byte[] audio = decryptedPacket.getEncodedAudio();
                                        if (Arrays.equals(audio, AudioConnection.this.silenceBytes)) continue;
                                        LOG.debug("Received audio data with an unknown SSRC id.");
                                        continue;
                                    }
                                    if (decoder == null) {
                                        LOG.warn("Received audio data with known SSRC, but opus decoder for this SSRC was null. uh..HOW?!");
                                        continue;
                                    }
                                    if (!decoder.isInOrder(decryptedPacket.getSequence())) {
                                        LOG.trace("Got out-of-order audio packet. Ignoring.");
                                        continue;
                                    }
                                    User user = AudioConnection.this.getJDA().getUserById(userId);
                                    if (user == null) {
                                        LOG.warn("Received audio data with a known SSRC, but the userId associate with the SSRC is unknown to JDA!");
                                        continue;
                                    }
                                    short[] decodedAudio = decoder.decodeFromOpus(decryptedPacket);
                                    if (decodedAudio == null) {
                                        LOG.trace("Received audio data but Opus failed to properly decode, instead it returned an error");
                                        continue;
                                    }
                                    if (AudioConnection.this.receiveHandler.canReceiveUser()) {
                                        AudioConnection.this.receiveHandler.handleUserAudio(new UserAudio(user, decodedAudio));
                                    }
                                    if (!AudioConnection.this.receiveHandler.canReceiveCombined()) continue;
                                    ConcurrentLinkedQueue<Pair<Long, short[]>> queue = (ConcurrentLinkedQueue<Pair<Long, short[]>>)AudioConnection.this.combinedQueue.get(user);
                                    if (queue == null) {
                                        queue = new ConcurrentLinkedQueue<Pair<Long, short[]>>();
                                        AudioConnection.this.combinedQueue.put(user, queue);
                                    }
                                    queue.add(Pair.of(System.currentTimeMillis(), decodedAudio));
                                    continue;
                                }
                                if (!AudioConnection.this.couldReceive) continue;
                                AudioConnection.this.couldReceive = false;
                                AudioConnection.this.sendSilentPackets();
                            }
                            catch (SocketTimeoutException decryptedPacket) {
                            }
                            catch (SocketException decryptedPacket) {
                            }
                            catch (Exception e) {
                                LOG.log(e);
                            }
                        }
                    }
                };
                this.receiveThread.setDaemon(true);
                this.receiveThread.start();
            }
            if (this.receiveHandler.canReceiveCombined()) {
                this.setupCombinedExecutor();
            }
        }
    }

    private void setupCombinedExecutor() {
        if (this.combinedAudioExecutor == null) {
            this.combinedAudioExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "AudioConnection CombinedAudio Guild: " + this.channel.getGuild().getId()));
            this.combinedAudioExecutor.scheduleAtFixedRate(() -> {
                try {
                    LinkedList<User> users = new LinkedList<User>();
                    LinkedList<short[]> audioParts = new LinkedList<short[]>();
                    if (this.receiveHandler != null && this.receiveHandler.canReceiveCombined()) {
                        long currentTime = System.currentTimeMillis();
                        for (Map.Entry<User, Queue<Pair<Long, short[]>>> entry : this.combinedQueue.entrySet()) {
                            User user = entry.getKey();
                            Queue<Pair<Long, short[]>> queue = entry.getValue();
                            if (queue.isEmpty()) continue;
                            Pair<Long, short[]> audioData = queue.poll();
                            while (audioData != null && currentTime - audioData.getLeft() > this.queueTimeout) {
                                audioData = queue.poll();
                            }
                            if (audioData == null) continue;
                            users.add(user);
                            audioParts.add(audioData.getRight());
                        }
                        if (!audioParts.isEmpty()) {
                            int audioLength = ((short[])audioParts.get(0)).length;
                            short[] mix = new short[1920];
                            for (int i = 0; i < audioLength; ++i) {
                                int sample = 0;
                                for (short[] audio : audioParts) {
                                    sample += audio[i];
                                }
                                mix[i] = sample > Short.MAX_VALUE ? Short.MAX_VALUE : (sample < Short.MIN_VALUE ? Short.MIN_VALUE : (short)sample);
                            }
                            this.receiveHandler.handleCombinedAudio(new CombinedAudio(users, mix));
                        } else {
                            this.receiveHandler.handleCombinedAudio(new CombinedAudio(new LinkedList<User>(), new short[1920]));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.log(e);
                }
            }, 0L, 20L, TimeUnit.MILLISECONDS);
        }
    }

    private byte[] encodeToOpus(byte[] rawAudio) {
        ShortBuffer nonEncodedBuffer = ShortBuffer.allocate(rawAudio.length / 2);
        ByteBuffer encoded = ByteBuffer.allocate(4096);
        for (int i = 0; i < rawAudio.length; i += 2) {
            int firstByte = 0xFF & rawAudio[i];
            int secondByte = 0xFF & rawAudio[i + 1];
            short toShort = (short)(firstByte << 8 | secondByte);
            nonEncodedBuffer.put(toShort);
        }
        nonEncodedBuffer.flip();
        int result = Opus.INSTANCE.opus_encode(this.opusEncoder, nonEncodedBuffer, 960, encoded, encoded.capacity());
        byte[] audio = new byte[result];
        encoded.get(audio);
        return audio;
    }

    private void setSpeaking(boolean isSpeaking) {
        this.speaking = isSpeaking;
        JSONObject obj = new JSONObject().put("op", 5).put("d", new JSONObject().put("speaking", isSpeaking).put("delay", 0));
        this.webSocket.send(obj.toString());
        if (!isSpeaking) {
            this.sendSilentPackets();
        }
    }

    private void sendSilentPackets() {
        this.silenceCounter = 0;
    }
}

